-- $Id: lextokenmanager-insert_nat.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with SPARK_IO;

separate (LexTokenManager)
procedure Insert_Nat (N       : in     Natural;
                      Lex_Str :    out Lex_String)
is
   subtype Ex_Str_T is String (ELStrings.Positions);
   Ex_Str  : Ex_Str_T;
   Wid     : ELStrings.Lengths;
   Ex_Lin  : ELStrings.T;
   Success : Boolean;

   function Width (N : Natural) return Natural
   is
      Num,
      Wid : Natural;
   begin
      Num := N;
      Wid := 0;
      loop
         Num := Num / 10;
         Wid := Wid + 1;
         exit when Num = 0;
      end loop;
      return Wid;
   end Width;

begin -- InsertNat
   Wid := Width (N);
   SPARK_IO.Put_Int_To_String (Dest    => Ex_Str,
                               Item    => N,
                               StartPt => Ex_Str'First,
                               Base    => 10);

   -- Initialize ExLin fully to avoid subsequent DF error(s)
   Ex_Lin := ELStrings.Empty_String;
   for I in ELStrings.Lengths range 1 .. Wid loop
      --# accept F, 10, Success, "Ineffective assignment here OK";
      ELStrings.Append_Char (E_Str   => Ex_Lin,
                             Ch      => Ex_Str ((ELStrings.Max_String_Length - Wid) + I),
                             Success => Success);
      --# end accept;
   end loop;
   Insert_General_Lex_String (Str     => Ex_Lin,
                              Lex_Str => Lex_Str);
   --# accept F, 33, Success, "Expect Success unused";
end Insert_Nat;
