-- $Id: indexmanager.ads 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

--------------------------------------------------------------------------------
--  IndexManager
--
--  Purpose:
--
--  The goal of this package is to manage the link between a package
--  name or a procedure/function name and the filename that contains
--  the subunit.
--
--------------------------------------------------------------------------------

with SPARK_IO;
with ContextManager;
with EStrings;
with ExaminerConstants;
with LexTokenLists;
with LexTokenManager;

use type SPARK_IO.File_Status;
use type LexTokenLists.Lists;
use type LexTokenManager.Str_Comp_Result;

--# inherit Ada.Characters.Latin_1,
--#         CommandLineData,
--#         ContextManager,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         FileSystem,
--#         LexTokenLists,
--#         LexTokenManager,
--#         ScreenEcho,
--#         SPARK_IO,
--#         SystemErrors,
--#         XMLReport;

package IndexManager
--# own LastChar : Character;
--#     State;
--# initializes LastChar,
--#             State;
is
   subtype ComponentIndex is Integer range 1 .. ExaminerConstants.MaxIndexComponents;

   type ComponentLists is array (ComponentIndex) of LexTokenLists.Lists;

   procedure LookUp (RequiredUnit      : in     LexTokenLists.Lists;
                     PossibleUnitTypes : in     ContextManager.UnitTypeSets;
                     SourceFileName    :    out LexTokenManager.Lex_String;
                     ActualUnitType    :    out ContextManager.UnitTypes;
                     Found             :    out Boolean);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --#           out LastChar;
   --# derives ActualUnitType,
   --#         ErrorHandler.ErrorContext,
   --#         Found,
   --#         LastChar,
   --#         LexTokenManager.State,
   --#         SourceFileName,
   --#         SPARK_IO.File_Sys,
   --#         State                     from CommandLineData.Content,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        PossibleUnitTypes,
   --#                                        RequiredUnit,
   --#                                        SPARK_IO.File_Sys,
   --#                                        State;

   procedure LookUpComponents (RequiredUnit : in     LexTokenLists.Lists;
                               Components   :    out ComponentLists);
   --# global in     CommandLineData.Content;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --#           out LastChar;
   --# derives Components,
   --#         ErrorHandler.ErrorContext,
   --#         LastChar,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         State                     from CommandLineData.Content,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        RequiredUnit,
   --#                                        SPARK_IO.File_Sys,
   --#                                        State;

   procedure Add_Unit (Unit            : in LexTokenLists.Lists;
                       Unit_Types      : in ContextManager.UnitTypes;
                       Source_Filename : in EStrings.T);
   --# global in     CommandLineData.Content;
   --#        in out LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --#        in out State;
   --# derives ErrorHandler.ErrorContext,
   --#         State                     from *,
   --#                                        LexTokenManager.State,
   --#                                        Source_Filename,
   --#                                        State,
   --#                                        Unit,
   --#                                        Unit_Types &
   --#         LexTokenManager.State     from *,
   --#                                        Source_Filename &
   --#         SPARK_IO.File_Sys         from *,
   --#                                        CommandLineData.Content,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        Source_Filename,
   --#                                        State,
   --#                                        Unit,
   --#                                        Unit_Types;

   procedure ListIndexFile (ReportFile : in SPARK_IO.File_Type);
   --# global in     CommandLineData.Content;
   --#        in     LexTokenManager.State;
   --#        in     State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out XMLReport.State;
   --# derives SPARK_IO.File_Sys from *,
   --#                                CommandLineData.Content,
   --#                                LexTokenManager.State,
   --#                                ReportFile,
   --#                                State,
   --#                                XMLReport.State &
   --#         XMLReport.State   from *,
   --#                                CommandLineData.Content,
   --#                                State;

private

   type EntryTypes is (SuperIndex,
                       AuxIndex,
                       mainp,
                       pspec,
                       -- GenOption -- GenericDec, -- See comment in body
                       pbodi,
                       subunit,
                       ComponentList,
                       InvalidEntryType);

   type LibraryManagerErrors is (ESFileLocation, ESIsIn, ESUnitEntry,
                                 EWIndex, EWUnexpectedSuper, ESComment,
                                 ESAre,
                                 ESComponents,
                                 EWIllegalUnitName,
                                 EWAux,
                                 EWSuper,
                                 ESRecursion,
                                 EFContradiction, EWDuplicate,
                                 EWDuplicateAux);

   type FilePosition is record
      Line : Positive;
      Col  : Positive;
   end record;

end IndexManager;
