-- $Id: indexmanager-cache.ads 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with ContextManager;
with EStrings;
with LexTokenManager;
with LexTokenLists;

--# inherit CommandLineData,
--#         ContextManager,
--#         ErrorHandler,
--#         EStrings,
--#         IndexManager,
--#         IndexManager.Index_Table_P,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SPARK_IO;
private package IndexManager.Cache
--# own The_Unit_Hash;
--# initializes The_Unit_Hash;
is

   procedure ContextManager_UnitTypes_Image (Unit_Type : in ContextManager.UnitTypes);
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Unit_Type;

   procedure Add_Unit (Unit            : in LexTokenLists.Lists;
                       Unit_Types      : in ContextManager.UnitTypes;
                       Source_Filename : in EStrings.T;
                       Index_Filename  : in LexTokenManager.Lex_String;
                       Index_Position  : in IndexManager.FilePosition);
   --# global in     CommandLineData.Content;
   --#        in     Index_Table_P.Index_Table;
   --#        in out LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Index_Table_P.Fatal_Error;
   --#        in out SPARK_IO.File_Sys;
   --#        in out The_Unit_Hash;
   --# derives ErrorHandler.ErrorContext,
   --#         Index_Table_P.Fatal_Error,
   --#         The_Unit_Hash             from *,
   --#                                        Index_Filename,
   --#                                        Index_Table_P.Index_Table,
   --#                                        LexTokenManager.State,
   --#                                        Source_Filename,
   --#                                        The_Unit_Hash,
   --#                                        Unit,
   --#                                        Unit_Types &
   --#         LexTokenManager.State     from *,
   --#                                        Source_Filename &
   --#         SPARK_IO.File_Sys         from *,
   --#                                        CommandLineData.Content,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Index_Filename,
   --#                                        Index_Position,
   --#                                        Index_Table_P.Index_Table,
   --#                                        LexTokenManager.State,
   --#                                        Source_Filename,
   --#                                        The_Unit_Hash,
   --#                                        Unit,
   --#                                        Unit_Types;

   procedure Get_Unit (Required_Unit   : in     LexTokenLists.Lists;
                       Unit_Types      : in     ContextManager.UnitTypes;
                       Source_Filename :    out LexTokenManager.Lex_String;
                       Index_Filename  :    out LexTokenManager.Lex_String;
                       Found           :    out Boolean);
   --# global in The_Unit_Hash;
   --# derives Found,
   --#         Index_Filename,
   --#         Source_Filename from Required_Unit,
   --#                              The_Unit_Hash,
   --#                              Unit_Types;

   procedure Add_Components (Unit           : in LexTokenLists.Lists;
                             Components     : in IndexManager.ComponentLists;
                             Index_Filename : in LexTokenManager.Lex_String;
                             Index_Position : in IndexManager.FilePosition);
   --# global in     CommandLineData.Content;
   --#        in     Index_Table_P.Index_Table;
   --#        in     LexTokenManager.State;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out Index_Table_P.Fatal_Error;
   --#        in out SPARK_IO.File_Sys;
   --#        in out The_Unit_Hash;
   --# derives ErrorHandler.ErrorContext,
   --#         Index_Table_P.Fatal_Error,
   --#         The_Unit_Hash             from *,
   --#                                        Components,
   --#                                        Index_Filename,
   --#                                        Index_Table_P.Index_Table,
   --#                                        LexTokenManager.State,
   --#                                        The_Unit_Hash,
   --#                                        Unit &
   --#         SPARK_IO.File_Sys         from *,
   --#                                        CommandLineData.Content,
   --#                                        Components,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        Index_Filename,
   --#                                        Index_Position,
   --#                                        Index_Table_P.Index_Table,
   --#                                        LexTokenManager.State,
   --#                                        The_Unit_Hash,
   --#                                        Unit;

   procedure Get_Components (Required_Unit  : in     LexTokenLists.Lists;
                             Components     :    out IndexManager.ComponentLists;
                             Index_Filename :    out LexTokenManager.Lex_String;
                             Found          :    out Boolean);
   --# global in The_Unit_Hash;
   --# derives Components,
   --#         Found,
   --#         Index_Filename from Required_Unit,
   --#                             The_Unit_Hash;
end IndexManager.Cache;
