-- $Id: flowanalyser-flowanalyse-analyserelations-checkexpressions.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (FlowAnalyser.FlowAnalyse.AnalyseRelations)
procedure CheckExpressions
is
   Expn,
   ZeroStableExpn,
   OneStableExpn,
   OtherStableExpn,
   Variable       : SeqAlgebra.MemberOfSeq;
   ExpnNmbr,
   VarNmbr        : Natural;
   VarSym         : Dictionary.Symbol;
   Intersecn,
   LambdaCol,
   MuRow,
   ThetaCol,
   ThetaTildeCol  : SeqAlgebra.Seq;


   procedure AddRecordComponentError (ErrClass : in     ComponentErrors.ErrorClass;
                                      ErrVal   : in     Natural;
                                      Position : in     LexTokenManager.Token_Position;
                                      Sym      : in     Dictionary.Symbol)
   --# global in     ComponentData;
   --#        in out Statistics.TableUsage;
   --#        in out TheErrorHeap;
   --#        in out TheHeap;
   --# derives Statistics.TableUsage,
   --#         TheHeap               from *,
   --#                                    ComponentData,
   --#                                    ErrClass,
   --#                                    ErrVal,
   --#                                    Position,
   --#                                    Sym,
   --#                                    TheErrorHeap,
   --#                                    TheHeap &
   --#         TheErrorHeap          from *,
   --#                                    ErrClass,
   --#                                    ErrVal,
   --#                                    Position,
   --#                                    TheHeap;
   is
      NewError : Natural;
   begin
      ComponentErrors.CreateError (TheErrorHeap,
                                   TheHeap,
                                   ErrClass,
                                   ErrVal,
                                   Position,
                                   Dictionary.NullSymbol,
                                    --to get
                                   NewError);

      ComponentManager.AddError (TheHeap,
                                 TheErrorHeap,
                                 ComponentData,
                                 ComponentManager.GetComponentNode (ComponentData, Sym),
                                 NewError);
   end AddRecordComponentError;

   ----------------------------

begin  --CheckExpressions
   Expn := SeqAlgebra.FirstMember (TheHeap, IFA_Stack.Top (S).SeqOfExpns);
   ZeroStableExpn := SeqAlgebra.FirstMember (TheHeap, ZeroStableExpnSeq);
   OneStableExpn := SeqAlgebra.FirstMember (TheHeap, OneStableExpnSeq);
   OtherStableExpn := SeqAlgebra.FirstMember (TheHeap, OtherStableExpnSeq);
   while not SeqAlgebra.IsNullMember (Expn) loop
      --# assert True;
      ExpnNmbr := SeqAlgebra.Value_Of_Member (The_Heap => TheHeap,
                                              M        => Expn);
      if KindDictionary (ExpnNmbr) /= ControlVarAssignment and then
        KindDictionary (ExpnNmbr) /= ModellingStmt then
         RelationAlgebra.ColExtraction (TheHeap,
                                        IFA_Stack.Top (S).Theta,
                                        ExpnNmbr,
                                        ThetaCol);
         RelationAlgebra.ColExtraction (TheHeap,
                                        IFA_Stack.Top (S).ThetaTilde,
                                        ExpnNmbr,
                                        ThetaTildeCol);
         SeqAlgebra.Reduction (TheHeap, ThetaCol, SeqOfInitVars);
         SeqAlgebra.Reduction (TheHeap, ThetaCol, ExpSeqOfImports);
         Variable := SeqAlgebra.FirstMember (TheHeap, ThetaCol);
         while not SeqAlgebra.IsNullMember (Variable) loop
            DataFlowErrorFoundLocal := True; -- signal presence of data flow error to caller
            --# assert True;
            VarNmbr := SeqAlgebra.Value_Of_Member (The_Heap => TheHeap,
                                                   M        => Variable);
            VarSym := Dictionary.ConvertSymbolRef (ExaminerConstants.RefType (VarNmbr));
            if SeqAlgebra.IsMember (TheHeap, ThetaTildeCol, VarNmbr) then
               --# accept Flow, 41, "Expected stable expression";
               case KindDictionary (ExpnNmbr) is
                  when ComplexAssignment |
                    FieldUpdateByProc =>
               --# end accept;
                     if Dictionary.IsRecordSubcomponent (VarSym) then
                        AddRecordComponentError
                          (ComponentErrors.DataFlow,
                           ErrorHandler.DataFlowErrType'Pos (ErrorHandler.StmtUndefined),
                           STree.NodePosition (StmtLocations (ExpnNmbr)),
                           VarSym);
                     else
                        ErrorHandler.DataFlowError
                          (ErrorHandler.StmtUndefined,
                           STree.NodePosition (StmtLocations (ExpnNmbr)),
                           VarSym,
                           Scope);
                     end if;
                  when others =>
                     if Dictionary.IsRecordSubcomponent (VarSym) then
                        AddRecordComponentError
                          (ComponentErrors.DataFlow,
                           ErrorHandler.DataFlowErrType'Pos (ErrorHandler.ExpnUndefined),
                           STree.NodePosition (ExpnLocations (ExpnNmbr)),
                           VarSym);
                     else
                        ErrorHandler.DataFlowError
                          (ErrorHandler.ExpnUndefined,
                           STree.NodePosition (ExpnLocations (ExpnNmbr)),
                           VarSym,
                           Scope);
                     end if;
               end case;
            else
               --# accept Flow, 41, "Expected stable expression";
               case KindDictionary (ExpnNmbr) is
                  when
                    ComplexAssignment |
                    FieldUpdateByProc =>
               --# end accept;
                     if Dictionary.IsRecordSubcomponent (VarSym) then
                        AddRecordComponentError
                          (ComponentErrors.DataFlow,
                           ErrorHandler.DataFlowErrType'Pos (ErrorHandler.StmtMayBeUndefined),
                           STree.NodePosition (StmtLocations (ExpnNmbr)),
                           VarSym);
                     else
                        ErrorHandler.DataFlowError
                          (ErrorHandler.StmtMayBeUndefined,
                           STree.NodePosition (StmtLocations (ExpnNmbr)),
                           VarSym,
                           Scope);
                     end if;
                  when others =>
                     if Dictionary.IsRecordSubcomponent (VarSym) then
                        AddRecordComponentError
                          (ComponentErrors.DataFlow,
                           ErrorHandler.DataFlowErrType'Pos (ErrorHandler.ExpnMayBeUndefined),
                           STree.NodePosition (ExpnLocations (ExpnNmbr)),
                           VarSym);
                     else
                        ErrorHandler.DataFlowError
                          (ErrorHandler.ExpnMayBeUndefined,
                           STree.NodePosition (ExpnLocations (ExpnNmbr)),
                           VarSym,
                           Scope);
                     end if;
               end case;
            end if;
            Variable := SeqAlgebra.NextMember (TheHeap, Variable);
         end loop;
         SeqAlgebra.DisposeOfSeq (TheHeap, ThetaCol);
         SeqAlgebra.DisposeOfSeq (TheHeap, ThetaTildeCol);

         --# assert True;

         RelationAlgebra.RowExtraction (TheHeap, IFA_Stack.Top (S).Mu, ExpnNmbr, MuRow);
         SeqAlgebra.Intersection (TheHeap, MuRow, ExpSeqOfExports, Intersecn);
         if SeqAlgebra.IsEmptySeq (TheHeap, Intersecn) then
            VarSym := ParamDictionary (ExpnNmbr);
            if VarSym /= Dictionary.GetNullVariable then -- don't report
               case KindDictionary (ExpnNmbr) is
                  when ComplexAssignment |
                    FieldUpdateByProc =>
                     if Dictionary.IsRecordSubcomponent (VarSym) then
                        if KindDictionary (ExpnNmbr) = ComplexAssignment then
                           AddRecordComponentError
                             (ComponentErrors.IneffectiveStmt,
                              0,
                              STree.NodePosition (StmtLocations (ExpnNmbr)),
                              VarSym);
                        else --must be a record field directly assigned by proc call
                           AddRecordComponentError
                             (ComponentErrors.IneffectiveFieldAssignment,
                              0,
                              STree.NodePosition (StmtLocations (ExpnNmbr)),
                              VarSym);
                        end if;
                     else
                        ErrorHandler.IneffectiveStmt
                          (STree.NodePosition (StmtLocations (ExpnNmbr)),
                           ParamDictionary (ExpnNmbr),
                           Scope);
                     end if;

                  when Initialization =>
                     --# accept Flow, 41, "Expected stable expression";
                     if Dictionary.IsSubprogram (SubprogSym) then
                     --# end accept;
                        if Dictionary.IsRecordSubcomponent (VarSym) then
                           AddRecordComponentError
                             (ComponentErrors.Dependency,
                              ErrorHandler.DependencyErrType'Pos (ErrorHandler.IneffLocalInit),
                              STree.NodePosition
                                (STree.RefToNode
                                   (Dictionary.GetVariableExpNode
                                      (ComponentManager.GetName
                                         (ComponentData,
                                          ComponentManager.GetRoot
                                            (ComponentData,
                                             ComponentManager.GetComponentNode
                                               (ComponentData,
                                                VarSym)))))),
                              VarSym);
                        else
                           ErrorHandler.DependencyError
                             (ErrorHandler.IneffLocalInit,
                              STree.NodePosition
                                (STree.RefToNode
                                   (Dictionary.GetVariableExpNode (ParamDictionary (ExpnNmbr)))),
                              VarSym,
                              Dictionary.NullSymbol,
                              Scope);
                        end if;
                     else --must be package
                        if Dictionary.IsRecordSubcomponent (VarSym) then
                           AddRecordComponentError
                             (ComponentErrors.Dependency,
                              ErrorHandler.DependencyErrType'Pos (ErrorHandler.IneffLocalInit),
                              EndPosition,
                              VarSym);
                        else
                           ErrorHandler.DependencyError (ErrorHandler.IneffLocalInit,
                                                         EndPosition,
                                                         VarSym,
                                                         Dictionary.NullSymbol,
                                                         Scope);
                        end if;
                     end if;

                  when others =>
                     ErrorHandler.IneffectiveStmt
                       (STree.NodePosition (StmtLocations (ExpnNmbr)),
                        Dictionary.NullSymbol,
                        Scope);
               end case;
            end if; -- null variable
         end if;
         SeqAlgebra.DisposeOfSeq (TheHeap, Intersecn);
         SeqAlgebra.DisposeOfSeq (TheHeap, MuRow);

         --# assert True;
         if (KindDictionary (ExpnNmbr) = ForkExpn) and
           not SeqAlgebra.IsMember (TheHeap, InnerExpns, ExpnNmbr) then
            RelationAlgebra.ColExtraction (TheHeap,
                                           IFA_Stack.Top (S).Lambda,
                                           ExpnNmbr,
                                           LambdaCol);
            SeqAlgebra.Intersection (TheHeap, LambdaCol, ExpSeqOfImports, Intersecn);
            if SeqAlgebra.IsEmptySeq (TheHeap, Intersecn) then
               ErrorHandler.DataFlowError
                 (ErrorHandler.InvariantExp,
                  STree.NodePosition (ExpnLocations (ExpnNmbr)),
                  Dictionary.NullSymbol,
                  Scope);
            end if;
            SeqAlgebra.DisposeOfSeq (TheHeap, LambdaCol);
            SeqAlgebra.DisposeOfSeq (TheHeap, Intersecn);
         end if;

         --# assert True;
         if not SeqAlgebra.IsNullMember (ZeroStableExpn) then
            if SeqAlgebra.Value_Of_Member (The_Heap => TheHeap,
                                           M        => ZeroStableExpn) = ExpnNmbr then
               if (KindDictionary (ExpnNmbr) = ExitExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableExitCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.IndexZero);
               elsif (KindDictionary (ExpnNmbr) = ForkExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableForkCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.IndexZero);
               end if;
               -- 898
               -- we also have a kind of stable exit in the case of a DefaultExitExpression
               -- inserted into infinite loops at the "End_of_loop" node so as to provide
               -- a syntactic exit point for the benefit of the flow analyser.  Since a
               -- DefaultExitExpression is neither an ExitExpn or a ForkExpn, it is ignored
               -- by the preceding if statement and no error is reported.

               ZeroStableExpn := SeqAlgebra.NextMember (TheHeap, ZeroStableExpn);
            end if;
         end if;

         --# assert True;
         if not SeqAlgebra.IsNullMember (OneStableExpn) then
            if SeqAlgebra.Value_Of_Member (The_Heap => TheHeap,
                                           M        => OneStableExpn) = ExpnNmbr then
               if (KindDictionary (ExpnNmbr) = ExitExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableExitCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.IndexOne);
               elsif (KindDictionary (ExpnNmbr) = ForkExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableForkCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.IndexOne);
               end if;
               OneStableExpn := SeqAlgebra.NextMember (TheHeap, OneStableExpn);
            end if;
         end if;

         --# assert True;
         if not SeqAlgebra.IsNullMember (OtherStableExpn) then
            if SeqAlgebra.Value_Of_Member (The_Heap => TheHeap,
                                           M        => OtherStableExpn) = ExpnNmbr then
               if (KindDictionary (ExpnNmbr) = ExitExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableExitCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.LargerIndex);
               elsif (KindDictionary (ExpnNmbr) = ForkExpn) then
                  ErrorHandler.StabilityError
                    (ErrorHandler.StableForkCond,
                     STree.NodePosition (ExpnLocations (ExpnNmbr)),
                     ErrorHandler.LargerIndex);
               end if;
               OtherStableExpn := SeqAlgebra.NextMember (TheHeap, OtherStableExpn);
            end if;
         end if;
      end if;
      Expn := SeqAlgebra.NextMember (TheHeap, Expn);
   end loop;
end CheckExpressions;
