-- $Id: errorhandler-getfileline.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler)
procedure GetFileLine
is
   CurLine         : EStrings.T;
   LineNoBeforeGet : LexTokenManager.Line_Numbers;
begin
   -- Handling of line containing eight-bit characters
   if SPARK_IO.End_Of_Line (ErrorContextRec.Source) then
      SPARK_IO.Skip_Line (ErrorContextRec.Source, 1);
      ErrorContextRec.LineNo := ErrorContextRec.LineNo + 1;
      ErrorContextRec.CurrentLine := EStrings.Empty_String;
   else
      LineNoBeforeGet := LexTokenManager.Line_Numbers (SPARK_IO.Line (ErrorContextRec.Source));
      EStrings.Get_Line (File  => ErrorContextRec.Source,
                         E_Str => CurLine);
      ErrorContextRec.CurrentLine := CurLine;
      ErrorContextRec.LineNo := ErrorContextRec.LineNo + 1;
      if EStrings.Get_Length (E_Str => ErrorContextRec.CurrentLine) = 0 then
         ErrorContextRec.CurrentLine := EStrings.Copy_String (Str => " -- *** ILLEGAL LINE REPLACED *** --");
      end if;
      if LineNoBeforeGet =
         LexTokenManager.Line_Numbers (SPARK_IO.Line (ErrorContextRec.Source))
      then
         SPARK_IO.Skip_Line (ErrorContextRec.Source, 1);
      end if;
   end if;
end GetFileLine;
