separate (ErrorHandler.Conversions.ToString.UsageError)
procedure UsageErrorExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.RedefinedImport =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The updating of imported-only variables is forbidden under all" &
              " circumstances.");
      when ErrorHandler.IneffectiveImport =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The meaning of this message is explained in Section 4.2 of Appendix A");
      when ErrorHandler.ReferencedButNotInPartition =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "This message is only issued when processing the partition annotation.  The partition annotation" &
              " must describe all the actions of the tasks and interrupt handlers making up the program.  Therefore," &
              " if a variable is imported somewhere in the program by a task or interrupt handler, then it must" &
              " also be an import at the partition level.  As well as the omission of explicit imports, this message is also" &
              " generated if the implicit imports of tasks and interrupt handlers are omitted.  For tasks this means" &
              " any variable the task suspends on and for interrupt handlers it means the name of the protected" &
              " object containing the handler or, if given, the name of the interrupt stream associated with the" &
              " handler.");
      when ErrorHandler.UpdatedButNotInPartition =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "This message is only issued when processing the partition annotation.  The partition annotation" &
              " must describe all the actions of the tasks and interrupt handlers making up the program.  Therefore," &
              " if a variable is exported somewhere in the program by a task or interrupt handler, then it must" &
              " also be an export at the partition level.");
      when ErrorHandler.UninitializedProtectedElement =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "To avoid potential race conditions during program startup, all" &
              " elements of a protected type must be initialized with a constant value" &
              " at the point of declaration.");
      when others => null;
   end case;
end UsageErrorExpl;
