separate (ErrorHandler.Conversions.ToString.UncondFlowErr)
procedure UncondFlowErrExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.ExpnUndefined =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The expression may be that in an assignment or return statement," &
              " an actual parameter," &
              " or a condition occurring in an if or case statement, an iteration" &
              " scheme or exit statement.  NOTE:  the presence of random and possibly invalid values" &
              " introduced by data flow errors invalidates proof of exception freedom for the" &
              " subprogram body which contains them.  All unconditional data flow errors must be" &
              " eliminated before attempting exception freedom proofs.  See the manual" &
              " ""SPARK Proof Manual"" for full details.");
      when ErrorHandler.StmtUndefined =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The statement here is a procedure call or an assignment to an array element, and the variable XXX may" &
              " appear in an actual parameter, whose value is imported when the" &
              " procedure is executed. If the variable XXX" &
              " does not occur in the actual parameter list, it is an imported" &
              " global variable of the procedure (named in its global definition)." &
              " NOTE:  the presence of random and possibly invalid values" &
              " introduced by data flow errors invalidates proof of exception freedom for the" &
              " subprogram body which contains them.  All unconditional data flow errors must be" &
              " eliminated before attempting exception freedom proofs.  See the manual" &
              " ""SPARK Proof Manual"" for full details.");
      when ErrorHandler.InvariantExp =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The expression is either a case expression or a condition" &
              " (Boolean-valued expression) associated with an if-statement, not" &
              " contained in a loop statement. The message indicates" &
              " that the expression takes the same value whenever it is evaluated," &
              " in all program executions.  Note that if the expression depends on values obtained" &
              " by a call to another other subprogram then a possible source for its invariance" &
              " might be an incorrect annotation on the called subprogram.");
      when others => null;
   end case;
end UncondFlowErrExpl;
