-- $Id: errorhandler-conversions-tostring-unconddependency.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure UncondDependency (ErrNum          : in     Error_Types.NumericError;
                            WithExplanation : in     Boolean;
                            EStr            : in out ELStrings.T)
is
   ErrType : ErrorHandler.FullDependErrType;


   procedure UncondDependencyExpl (EStr   : in out ELStrings.T)
   --# global in ErrType;
   --# derives EStr from *,
   --#                   ErrType;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrType;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrType,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.Empty_String;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         UncondDependencyExpl (ExplanationString);
         if ELStrings.Get_Length (E_Str => ExplanationString) > 0 then
            -- there actually is one
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPrefix);
            ELStrings.Append_Examiner_Long_String (E_Str1 => EStr,
                                                   E_Str2 => ExplanationString);
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin
   ErrType := ErrorHandler.DependencyErrType'Val (ErrNum.ErrorNum -
                                                  Error_Types.UncondDependencyErrorOffset);
   case ErrType is

      -- HTML Directives
      --! <NameFormat> <"flow-"><Name>
      --! <ErrorFormat> <"!!! Flow Error : "><Name><" : "><Error>

      when ErrorHandler.NotUsedNew =>
         --! <Name> 50
         AppendExportVar (EStr, ErrNum.Name2, ErrNum.Scope, True);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => " is not derived from the imported value(s) of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         --! The item before &quot;is not derived ...&quot; is an export or function return value and the item(s)
         --! after are imports of the subprogram.  The message indicates that a dependency, stated in the dependency
         --! relation (derives annotation) or implied by the function signature is not present in the code.
         --! The absence of a stated dependency
         --! is always an error in either code or annotation.

      when ErrorHandler.NotUsed =>
         --! <Name> 50
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "The imported value of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => " is not used in the derivation of ");
         AppendExportVar (EStr, ErrNum.Name2, ErrNum.Scope, False);
         --! The variable XXX, which appears in the dependency relation of a
         --! procedure subprogram, as an import from which the export YYY is derived,
         --! is not used in the code for that purpose. YYY may be a function return value.
         --! This version of the message has been retained for backward compatibility.

      when ErrorHandler.NotUsedContinue =>
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => ", ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);

      when ErrorHandler.IneffInit =>
         --! <Name> 53
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "The package initialization of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => " is ineffective");
         --! Here XXX is an own variable of a package, initialized in the package
         --! initialization.
         --! The message states that XXX is updated elsewhere, before being read.

      when ErrorHandler.IneffLocalInit =>
         --! <Name> 54
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "The initialization at declaration of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => " is ineffective");
         --! Issued if the value assigned to a variable at declaration cannot
         --! affect the final value of any exported variable of the subprogram in
         --! which it occurs because, for example, it is overwritten before it is used.

      when others =>
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "UNKNOWN ERROR NUMBER PASSED TO UncondDependency");
   end case;
   AppendExplanation;
   if ErrType /= ErrorHandler.NotUsedContinue and
     ErrType /= ErrorHandler.NotUsedNew then
      ELStrings.Append_String (E_Str => EStr,
                               Str   => ".");
   end if;
end UncondDependency;
