separate (ErrorHandler.Conversions.ToString.UncondDependency)
procedure UncondDependencyExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.NotUsedNew =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The item before ""is not derived ..."" is an export or function return value and the item(s)" &
              " after are imports of the subprogram.  The message indicates that a dependency, stated in the dependency" &
              " relation (derives annotation) or implied by the function signature is not present in the code." &
              " The absence of a stated dependency" &
              " is always an error in either code or annotation.");
      when ErrorHandler.NotUsed =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The variable XXX, which appears in the dependency relation of a" &
              " procedure subprogram, as an import from which the export YYY is derived," &
              " is not used in the code for that purpose. YYY may be a function return value." &
              " This version of the message has been retained for backward compatibility.");
      when ErrorHandler.IneffInit =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Here XXX is an own variable of a package, initialized in the package" &
              " initialization." &
              " The message states that XXX is updated elsewhere, before being read.");
      when ErrorHandler.IneffLocalInit =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Issued if the value assigned to a variable at declaration cannot" &
              " affect the final value of any exported variable of the subprogram in" &
              " which it occurs because, for example, it is overwritten before it is used.");
      when others => null;
   end case;
end UncondDependencyExpl;
