-- $Id: errorhandler-conversions-tostring-note.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure Note (ErrNum          : in     Error_Types.NumericError;
                WithExplanation : in     Boolean;
                EStr            : in out ELStrings.T)
is
   procedure NoteExpl (EStr   : in out ELStrings.T)
   --# global in ErrNum;
   --# derives EStr from *,
   --#                   ErrNum;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrNum;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrNum,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.Empty_String;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         NoteExpl (ExplanationString);
         if ELStrings.Get_Length (E_Str => ExplanationString) > 0 then
            -- there actually is one
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPrefix);
            ELStrings.Append_Examiner_Long_String (E_Str1 => EStr,
                                                   E_Str2 => ExplanationString);
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin

   -- HTML Directives
   --! <NameFormat> <"note-"><Name>
   --! <ErrorFormat> <"--- note : "><Name><" : "><Error>

   case ErrNum.ErrorNum is
      when 1 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "This dependency relation was not used " &
              "for this analysis and has not been checked " &
              "for accuracy");
         --! Issued when information flow analysis is not performed and when
         --! modes were specified in the global annotation. It is a reminder
         --! that the dependencies specified in this annotation
         --! (including whether each variable is an import or an export) have
         --! not been checked against the code, and may therefore be incorrect.
         --! (warning control file keyword:<b> notes</b>)

      when 2 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "This dependency relation has been used " &
              "only to identify imports and exports, " &
              "dependencies have been ignored");
         --! Issued as a reminder when information flow analysis is not
         --! performed in SPARK 83. The dependencies specified in this annotation
         --! have not been checked against the code, and may
         --! therefore be incorrect. (warning control file keyword: <b>notes</b>)

      when 3 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "The deferred constant Null_Address " &
              "has been implicitly defined here");
         --! Issued as a reminder that the declaration of the type Address
         --! within the target configuration file
         --! implicitly defines a deferred constant of type Null_Address.
         --! (warning control file keyword:<b> notes</b>)

      when 4 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "The constant Default_Priority, of type " &
              "Priority, has been implicitly defined here");
         --! Issued as a reminder that the declaration of the subtype
         --! Priority within the target configuration file implicitly defines
         --! a constant Default_Priority, of type Priority, with the value
         --! (Priority'First + Priority'Last) / 2.
         --! (warning control file keyword:<b> notes</b>)

      when others =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "UNKNOWN ERROR NUMBER PASSED TO Convert.Note");

   end case;
   AppendExplanation;
   ELStrings.Append_String (E_Str => EStr,
                            Str   => ".");
end Note;
