separate (ErrorHandler.Conversions.ToString.Note)
procedure NoteExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrNum.ErrorNum is
      when 1 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Issued when information flow analysis is not performed and when" &
              " modes were specified in the global annotation. It is a reminder" &
              " that the dependencies specified in this annotation" &
              " (including whether each variable is an import or an export) have" &
              " not been checked against the code, and may therefore be incorrect." &
              " (warning control file keyword: notes)");
      when 2 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Issued as a reminder when information flow analysis is not" &
              " performed in SPARK 83. The dependencies specified in this annotation" &
              " have not been checked against the code, and may" &
              " therefore be incorrect. (warning control file keyword: notes)");
      when 3 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Issued as a reminder that the declaration of the type Address" &
              " within the target configuration file" &
              " implicitly defines a deferred constant of type Null_Address." &
              " (warning control file keyword: notes)");
      when 4 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Issued as a reminder that the declaration of the subtype" &
              " Priority within the target configuration file implicitly defines" &
              " a constant Default_Priority, of type Priority, with the value" &
              " (Priority'First + Priority'Last) / 2." &
              " (warning control file keyword: notes)");
      when others => null;
   end case;
end NoteExpl;
