-- $Id: errorhandler-conversions-tostring-noerr.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure NoErr (ErrNum : in     Error_Types.NumericError;
                 EStr   : in out ELStrings.T)
is
begin
   ELStrings.Append_String (E_Str => EStr,
                            Str   => "Flow analysis of");
   if ErrNum.Name1 = Error_Types.NoName then
      ELStrings.Append_String (E_Str => EStr,
                               Str   => " package initialization");
   elsif ErrNum.Name1 = Error_Types.ThePartitionName then
      ELStrings.Append_String (E_Str => EStr,
                               Str   => " the entire partition");
   else
      ELStrings.Append_String (E_Str => EStr,
                               Str   => " subprogram ");
      AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
   end if;
   ELStrings.Append_String (E_Str => EStr,
                            Str   => " performed: no errors found");
   ELStrings.Append_String (E_Str => EStr,
                            Str   => ".");
end NoErr;
