separate (ErrorHandler.Conversions.ToString.IneffectiveStatement)
procedure IneffectiveStatementExpl (EStr   : in out ELStrings.T)

is
begin
   if ErrNum.Name1 = Error_Types.NoName then
      ELStrings.Append_String
         (E_Str => EStr,
             Str   => "Execution of this statement cannot affect the final value of any exported" &
           " variable of the subprogram in which it occurs. The cause may be a" &
           " data-flow anomaly (i.e. the statement could be an assignment to a" &
           " variable, which is always updated again before it is read. However," &
           " statements may be ineffective for other reasons - see Section 4.1 of" &
           " Appendix A.");
   else
      ELStrings.Append_String
         (E_Str => EStr,
             Str   => "This message always relates to a procedure call or an assignment to a" &
           " record. The variable XXX may be an actual parameter corresponding to a" &
           " formal one that is exported;" &
           " otherwise XXX is an exported global variable of the procedure." &
           " The message indicates that" &
           " the updating of XXX, as a result of the procedure call, has no effect on" &
           " any final values of exported variables of the calling subprogram." &
           " Where the ineffective assignment is expected (e.g. calling a supplied" &
           " procedure that returns more parameters than are needed for the immediate purpose)," &
           " it can be a useful convention to choose a distinctive name, such as ""Unused"" for" &
           " the actual parameter concerned.  The message ""Assignment to Unused is ineffective""" &
           " is then self-documenting.");
   end if;
end IneffectiveStatementExpl;
