-- $Id: errorhandler-conversions-tostring-depsemanticerr.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure DepSemanticErr (ErrNum          : in     Error_Types.NumericError;
                          WithExplanation : in     Boolean;
                          EStr            : in out ELStrings.T)
is
   procedure DepSemanticErrExpl (EStr   : in out ELStrings.T)
   --# global in ErrNum;
   --# derives EStr from *,
   --#                   ErrNum;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrNum;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrNum,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.Empty_String;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         DepSemanticErrExpl (ExplanationString);
         if ELStrings.Get_Length (E_Str => ExplanationString) > 0 then
            -- there actually is one
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPrefix);
            ELStrings.Append_Examiner_Long_String (E_Str1 => EStr,
                                                   E_Str2 => ExplanationString);
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin
   case ErrNum.ErrorNum is

      -- HTML Directives
      --! <NameFormat> <"flow-"><Name>
      --! <ErrorFormat> <"!!! Flow Error : "><Name><" : "><Error>

      when 1 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "The previously stated updating of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => " has been omitted");
         --! XXX occurred as an export in the earlier dependency relation but
         --! neither XXX nor any refinement constituent of it occurs in the
         --! refined dependency relation.

      when 2 =>
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "The updating of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => " has not been previously stated");
         --! A refinement constituent of XXX occurs as an export in the
         --! refined dependency relation but XXX does not occur as an export in
         --! the earlier dependency relation.

      when 3 =>
         ELStrings.Append_String
           (E_Str => EStr,
            Str   => "The previously stated dependency of the exported value of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " on the imported value of ");
         AppendName (EStr, ErrNum.Name2, ErrNum.Scope);
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " has been omitted");
         --! The dependency of the exported value of XXX on the imported value
         --! of YYY occurs in the earlier dependency relation but in the refined
         --! dependency relation, no constituents of XXX
         --! depend on any constituents of YYY.

      when 4 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The dependency of the exported value of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " on the imported value of ");
         AppendName (EStr, ErrNum.Name2, ErrNum.Scope);
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " has not been previously stated");
         --! A refined dependency relation states a dependency of XXX or a
         --! constituent of XXX on YYY or a constituent of YYY, but in the
         --! earlier relation, no dependency of XXX on YYY is stated.

      when 5 =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The (possibly implicit) dependency of the exported value of ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " on its imported value");
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => " has not been previously stated");
         --! Either a dependency of a constituent of XXX on at least one
         --! constituent of XXX occurs in the refined dependency relation, or
         --! not all the constituents of XXX occur as exports in
         --! the refined dependency relation. However, the dependency of XXX on
         --! itself does not occur in the earlier dependency relation.

      when others =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "UNKNOWN ERROR NUMBER PASSED TO DepSemanticErr");
   end case;
   AppendExplanation;
   ELStrings.Append_String (E_Str => EStr,
                            Str   => ".");
end DepSemanticErr;
