separate (ErrorHandler.Conversions.ToString.ControlFlowError)
procedure ControlFlowErrorExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.MisplacedExit =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Exit statements must be of the form ""exit when c;"" where the closest" &
              " enclosing statement is a loop or ""if c then S; exit;"" where the" &
              " if statement has no else part and its closest enclosing" &
              " statement is a loop.  See the SPARK Definition for details.");
      when ErrorHandler.MisplacedReturn =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "A return statement may only occur as the last statement of a function.");
      when ErrorHandler.MissingReturn =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "SPARK requires that the last statement of a function be a return statement.");
      when others => null;
   end case;
end ControlFlowErrorExpl;
