-- $Id: errorhandler-conversions-tostring-condlflowerr.adb 15573 2010-01-12 15:24:43Z Robin Messer $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure CondlFlowErr (ErrNum          : in     Error_Types.NumericError;
                        WithExplanation : in     Boolean;
                        EStr            : in out ELStrings.T)
is
   ErrType : ErrorHandler.DataFlowErrType;

   procedure CondlFlowErrExpl (EStr   : in out ELStrings.T)
   --# global in ErrType;
   --# derives EStr from *,
   --#                   ErrType;
      is separate;
   -- Note that the parameter names for this subunit are chosen to make it as easy as
   --      possible to auto-generate the subunit from this, its parent, file.  The
   --      generation requires copying the case statement below, stripping out the
   --      current Append'Thing' statements and adding an AppendString for the
   --      explanatory text that is delineated by --! comments.

   procedure AppendExplanation
   --# global in     ErrType;
   --#        in     WithExplanation;
   --#        in out EStr;
   --# derives EStr from *,
   --#                   ErrType,
   --#                   WithExplanation;
   is
      ExplanationString : ELStrings.T := ELStrings.Empty_String;
   begin
      if WithExplanation then
         -- we need to at least look for an explanation
         CondlFlowErrExpl (ExplanationString);
         if ELStrings.Get_Length (E_Str => ExplanationString) > 0 then
            -- there actually is one
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPrefix);
            ELStrings.Append_Examiner_Long_String (E_Str1 => EStr,
                                                   E_Str2 => ExplanationString);
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => ErrorHandler.ExplanationPostfix);
         end if;
      end if;
   end AppendExplanation;

begin
   ErrType := ErrorHandler.DataFlowErrType'Val (ErrNum.ErrorNum -
                                                Error_Types.CondFlowErrorOffset);
   case ErrType is

      -- HTML Directives
      --! <NameFormat> <"flow-"><Name>
      --! <ErrorFormat> <"??? Flow Error : "><Name><" : "><Error>

      when ErrorHandler.ExpnMayBeUndefined =>
         --! <Name> 501
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "Expression contains reference(s) to variable ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => ", which may have an undefined value");
         --! The expression may be that in an assignment or return statement,
         --! an actual parameter,
         --! or a condition occurring in an if or case statement, an iteration
         --! scheme or exit statement.  The Examiner has identified at least one syntactic path
         --! to this point where the variable has NOT been given a value.  Conditional
         --! data flow errors are extremely serious and must be carefully investigated.
         --! NOTE:  the presence of random and possibly invalid values
         --! introduced by data flow errors invalidates proof of exception freedom for the
         --! subprogram body which contains them.  All reports of data flow errors must be
         --! eliminated or shown to be associated with semantically infeasible paths before
         --! attempting exception freedom proofs.  See the manual &quot;SPARK Proof Manual
         --! &quot; for full details.
      when ErrorHandler.StmtMayBeUndefined =>
         --! <Name> 504
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "Statement contains reference(s) to variable ");
         AppendName (EStr, ErrNum.Name1, ErrNum.Scope);
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => ", which may have an undefined value");
         --! The statement here is a procedure call, and the variable XXX may
         --! appear in an actual parameter, whose value is imported when the
         --! procedure is executed. If the variable XXX
         --! does not occur in the actual parameter list, it is an imported
         --! global variable of the procedure (named in its global definition).
         --! The Examiner has identified at least one syntactic path
         --! to this point where the variable has NOT been given a value.  Conditional
         --! data flow errors are extremely serious and must be carefully investigated.
         --! NOTE:  the presence of random and possibly invalid values
         --! introduced by data flow errors invalidates proof of exception freedom for the
         --! subprogram body which contains them.  All reports of data flow errors must be
         --! eliminated or shown to be associated with semantically infeasible paths before
         --! attempting exception freedom proofs.  See the manual &quot;SPARK Proof Manual
         --! &quot; for full details.
      when others =>
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => "UNKNOWN ERROR NUMBER PASSED TO CondlFlowError");
   end case;
   AppendExplanation;
   ELStrings.Append_String (E_Str => EStr,
                            Str   => ".");
end CondlFlowErr;
