separate (ErrorHandler.Conversions.ToString.CondlFlowErr)
procedure CondlFlowErrExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.ExpnMayBeUndefined =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The expression may be that in an assignment or return statement," &
              " an actual parameter," &
              " or a condition occurring in an if or case statement, an iteration" &
              " scheme or exit statement.  The Examiner has identified at least one syntactic path" &
              " to this point where the variable has NOT been given a value.  Conditional" &
              " data flow errors are extremely serious and must be carefully investigated." &
              " NOTE:  the presence of random and possibly invalid values" &
              " introduced by data flow errors invalidates proof of exception freedom for the" &
              " subprogram body which contains them.  All reports of data flow errors must be" &
              " eliminated or shown to be associated with semantically infeasible paths before" &
              " attempting exception freedom proofs.  See the manual ""SPARK Proof Manual" &
              " "" for full details.");
      when ErrorHandler.StmtMayBeUndefined =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "The statement here is a procedure call, and the variable XXX may" &
              " appear in an actual parameter, whose value is imported when the" &
              " procedure is executed. If the variable XXX" &
              " does not occur in the actual parameter list, it is an imported" &
              " global variable of the procedure (named in its global definition)." &
              " The Examiner has identified at least one syntactic path" &
              " to this point where the variable has NOT been given a value.  Conditional" &
              " data flow errors are extremely serious and must be carefully investigated." &
              " NOTE:  the presence of random and possibly invalid values" &
              " introduced by data flow errors invalidates proof of exception freedom for the" &
              " subprogram body which contains them.  All reports of data flow errors must be" &
              " eliminated or shown to be associated with semantically infeasible paths before" &
              " attempting exception freedom proofs.  See the manual ""SPARK Proof Manual" &
              " "" for full details.");
      when others => null;
   end case;
end CondlFlowErrExpl;
