separate (ErrorHandler.Conversions.ToString.CondlDependency)
procedure CondlDependencyExpl (EStr   : in out ELStrings.T)

is
begin
   case ErrType is
      when ErrorHandler.MayBeUsedNew =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Here the item on the left of ""may be derived from ..."" is an exported variable and" &
              " the item(s) on the right are imports of a procedure subprogram." &
              " The message reports a possible dependency, found in the code, which" &
              " does not appear in the specified dependency relation (derives annotation)." &
              " The discrepancy could be caused by an error in the subprogram code which implements" &
              " an unintended dependency.  It could also be in an error in the subprogram derives annotation" &
              " which omits a necessary and intended dependency.  Finally, the Examiner may be reporting" &
              " a false coupling between two items resulting from a non-executable code path or the" &
              " sharing of disjoint parts of structured or abstract data (e.g one variable writing to one element" &
              " of an array and another variable reading back a different element)." &
              " Unexpected dependencies should be investigated carefully and only accepted without modification" &
              " of either code or annotation if it is certain they are of ""false coupling"" kind.");
      when ErrorHandler.MayBeUsed =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Here first item is an import and the second is an export of a procedure subprogram." &
              " The message reports a possible dependency, found in the code, which" &
              " does not appear in the specified dependency relation." &
              " This version of the message has been retained for backward compatibility.");
      when ErrorHandler.Uninitialised =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Here XXX is a non-imported variable, and YYY is an export, of a" &
              " procedure subprogram.");
      when ErrorHandler.IntegrityViolation =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "This message indicates a violation of security or safety policy, such" &
              " as information flow from a Secret input to an Unclassified output.");
      when ErrorHandler.MayBeIntegrityViolation =>
         ELStrings.Append_String
            (E_Str => EStr,
             Str   => "Here XXX is an import and YYY is an export of a procedure subprogram." &
              " The message reports a possible dependency, found in the code, which" &
              " does not appear in the specified dependency relation. If this dependency" &
              " did appear in the dependency relation, then it would also constitute" &
              " an integrity violation.");
      when others => null;
   end case;
end CondlDependencyExpl;
