-- $Id: errorhandler-conversions-tostring-appendreference.adb 15559 2010-01-12 10:34:56Z rod chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (ErrorHandler.Conversions.ToString)
procedure AppendReference (EStr      : in out ELStrings.T;
                           Reference : in     Natural)
is
   subtype Index12 is Positive range 1 .. 12;
   subtype Paras  is String (Index12);

   type References is record
      Source       : Sources;
      Para         : Paras;
   end record;

   --e.g. ALRM 12.3.4(6) == References'(LRM, Paras'("12.3.4(6)   "));

   EmptyReference : constant References := References'(Nul,
                                                       Paras'("            "));

   MaxReferences : constant Positive := 22;  --INCREMENT WHEN ADDING REFS
   subtype ReferenceIndexes is Positive range 1 .. MaxReferences;
   type ReferenceTables is array (ReferenceIndexes, CommandLineData.LanguageProfiles) of References;

   -- References arranged thus:
   --
   -- RefNo => (Spark83-ref,
   --           Spark95-ref,
   --           Spark2005-ref)

   ReferenceTable : constant ReferenceTables := ReferenceTables'
      (1   => (CommandLineData.SPARK83   => References'(LRM, Paras'("4.9         ")),
               CommandLineData.SPARK95   => EmptyReference,
               CommandLineData.SPARK2005 => EmptyReference),

       2   => (CommandLineData.SPARK83   => References'(LRM, Paras'("3.3.3(9)    ")),
               CommandLineData.SPARK95   => EmptyReference,
               CommandLineData.SPARK2005 => EmptyReference),

       3   => (CommandLineData.SPARK83   => References'(LRM, Paras'("3.6.1(3)    ")),
               CommandLineData.SPARK95   => EmptyReference,
               CommandLineData.SPARK2005 => EmptyReference),

       4   => (CommandLineData.SPARK83   => EmptyReference,
               CommandLineData.SPARK95   => References'(LRM,   Paras'("7.2(4)      ")),
               CommandLineData.SPARK2005 => EmptyReference),

       5   => (CommandLineData.SPARK83   => References'(SR83,  Paras'("5.2.1       ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("5.2.1       ")),
               CommandLineData.SPARK2005 => EmptyReference),

       6   => (CommandLineData.SPARK83   => References'(SR83,  Paras'("3.6.3       ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("3.6.3       ")),
               CommandLineData.SPARK2005 => EmptyReference),

       7   => (CommandLineData.SPARK83   => References'(SR83,  Paras'("4.1         ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("4.1         ")),
               CommandLineData.SPARK2005 => EmptyReference),

       8   => (CommandLineData.SPARK83   => References'(LRM, Paras'("5.2(3)      ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("5.2(4)      ")),
               CommandLineData.SPARK2005 => EmptyReference),

       9   => (CommandLineData.SPARK83   => EmptyReference,
               CommandLineData.SPARK95   => References'(LRM, Paras'("J.3         ")),
               CommandLineData.SPARK2005 => EmptyReference),

       10  => (CommandLineData.SPARK83   => References'(LRM, Paras'("3.2.2(1)    ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("3.3.2(3)    ")),
               CommandLineData.SPARK2005 => EmptyReference),

       11  => (CommandLineData.SPARK83   => References'(LRM, Paras'("6.3.1(5)    ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("6.3.1(18)   ")),
               CommandLineData.SPARK2005 => EmptyReference),

       12  => (CommandLineData.SPARK83   => References'(LRM, Paras'("7.4(4)      ")),
               CommandLineData.SPARK95   => EmptyReference,
               CommandLineData.SPARK2005 => EmptyReference),

       13  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("3.2(Note2)  ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("3.2(Note2)  ")),
               CommandLineData.SPARK2005 => EmptyReference),

       14  => (CommandLineData.SPARK83   => References'(LRM, Paras'("5.2(2)      ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("5.2(2)      ")),
               CommandLineData.SPARK2005 => EmptyReference),

       15  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("3.3.2       ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("3.3.2       ")),
               CommandLineData.SPARK2005 => EmptyReference),

       16  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("7.3.1       ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("7.3.1       ")),
               CommandLineData.SPARK2005 => EmptyReference),

       17  => (CommandLineData.SPARK83   => References'(LRM, Paras'("10.2(3)     ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("10.1.3(13)  ")),
               CommandLineData.SPARK2005 => EmptyReference),

       18  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("3.9(1)      ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("3.9(1)      ")),
               CommandLineData.SPARK2005 => EmptyReference),

       19  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("6.3         ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("6.3         ")),
               CommandLineData.SPARK2005 => EmptyReference),

       20  => (CommandLineData.SPARK83   => References'(SR83,  Paras'("7.2.3       ")),
               CommandLineData.SPARK95   => References'(SR95,  Paras'("7.2.3       ")),
               CommandLineData.SPARK2005 => EmptyReference),

       21  => (CommandLineData.SPARK83   => References'(LRM, Paras'("6.3(3)      ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("6.1(20)     ")),
               CommandLineData.SPARK2005 => EmptyReference),

       22  => (CommandLineData.SPARK83   => References'(LRM, Paras'("4.6(3)      ")),
               CommandLineData.SPARK95   => References'(LRM, Paras'("4.6(61)     ")),
               CommandLineData.SPARK2005 => EmptyReference)
       );


   CurrentReference : References;

   --------------------------------------

   procedure AppendSource (EStr   : in out ELStrings.T;
                           Source : in     Sources)
      --# derives EStr from *,
      --#                   Source;
   is
   begin
      case Source is
         when Nul     => null;
         when LRM     => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "Ada LRM ");
         when SR83    => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "SR83 ");
         when SR95    => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "SR95 ");
         when UM      => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "User Manual ");
         when ProofUM => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "Proof Manual ");
         when JB      => ELStrings.Append_String (E_Str => EStr,
                                                  Str   => "Barnes ");
      end case;
   end AppendSource;

   --------------------------------------

   procedure AppendPara (EStr   : in out ELStrings.T;
                         Para   : in     Paras)
      --# derives EStr from *,
      --#                   Para;
   is
      Ok : Boolean;
   begin
      for I in Index12 loop
         exit when Para (I) = ' ';
         ELStrings.Append_Char (E_Str   => EStr,
                                Ch      => Para (I),
                                Success => Ok);
         exit when not Ok;
      end loop;
   end AppendPara;

   --------------------------------------

begin --AppendReference
   if Reference /= ErrorHandler.NoReference and
      not CommandLineData.Content.PlainOutput then

      if Reference > MaxReferences then
         ELStrings.Append_String (E_Str => EStr,
                                  Str   => " [Ref No Too High]");
      else
         CurrentReference := ReferenceTable (Reference, CommandLineData.Content.LanguageProfile);
         if CurrentReference /= EmptyReference then
            SourceUsed (CurrentReference.Source) := True;
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => " [");
            AppendSource (EStr, CurrentReference.Source);
            AppendPara (EStr, CurrentReference.Para);
            ELStrings.Append_String (E_Str => EStr,
                                     Str   => "]");
         end if;
      end if;
   end if;
end AppendReference;
