-- $Id: dictionary-writeproofstatement.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure WriteProofStatement (Discriminant : in ProofStatementDiscriminant;
                               Statement    : in Location)
is

   --------------------------------------------------------------------------------

   procedure WriteDiscriminant (File         : in SPARK_IO.File_Type;
                                Discriminant : in ProofStatementDiscriminant)
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Discriminant,
   --#                                File;
   is
   begin
      case Discriminant is
         when AssertStatement =>
            WriteString (File, "assert statement");
         when CheckStatement =>
            WriteString (File, "check statement");
      end case;
   end WriteDiscriminant;

   -------------------------------------------------------------------------------

begin
   if SPARK_IO.Is_Open (Dict.TemporaryFile) then
      WriteDiscriminant (Dict.TemporaryFile, Discriminant);
      WriteString (Dict.TemporaryFile, " at ");
      WriteLocation (Dict.TemporaryFile, Statement);
      WriteLine (Dict.TemporaryFile, " ;");
   end if;
end WriteProofStatement;
