-- $Id: dictionary-writename.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure WriteName (File : in SPARK_IO.File_Type; Item : in Symbol)
is
   LocalItem    : Symbol;

   --------------------------------------------------------------------------------

   procedure WritePrefix (File : in SPARK_IO.File_Type; Item : in Symbol)
      --# global in     Dict;
      --#        in     LexTokenManager.State;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                Dict,
      --#                                File,
      --#                                Item,
      --#                                LexTokenManager.State;
   is

      Prefix, Name : EStrings.T;
      Region       : Symbol;
      Scope        : Scopes;

      --------------------------------------------------------------------------------

      function AppendName (Prefix, Suffix : EStrings.T) return EStrings.T
      is
         Name : EStrings.T;
      begin
         Name := Prefix;
         EStrings.Append_String (E_Str => Name,
                                 Str   => ".");
         EStrings.Append_Examiner_String (E_Str1 => Name,
                                          E_Str2 => Suffix);
         return Name;
      end AppendName;

      --------------------------------------------------------------------------------

   begin
      Prefix := EStrings.Empty_String;
      if Item /= GetPredefinedPackageStandard then -- don't try and get a prefix for this!
         Scope := GetScope (Item);
         loop
            Region := GetRegion (Scope);
            exit when Region = GetPredefinedPackageStandard;
            GenerateSimpleName (Region, ".", Name);
            Prefix := AppendName (Name, Prefix);
            Scope := GetEnclosingScope (Scope);
         end loop;
      end if;
      EStrings.Put_String (File  => File,
                           E_Str => Prefix);
   end WritePrefix; -- Init of Prefix is partial but effective.

   --------------------------------------------------------------------------------

begin
   LocalItem := Item;

   if IsType (LocalItem) and then TypeIsAccess (LocalItem) then
      SPARK_IO.Put_String (File, "access ", 0);
      LocalItem := DeReference (LocalItem);
   end if;

   if not IsUnknownTypeMark (Item) then
      WritePrefix (File, LocalItem);
   end if;
   WriteSimpleName (File, LocalItem);
end WriteName;
