-- $Id: dictionary-isrenamed.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function IsRenamed (Subprogram : Symbol; Scope : Scopes) return Boolean
is

   Current : Scopes;
   Region  : Symbol;
   Found   : Boolean;

   --------------------------------------------------------------------------------

   function IsRenamedInThisScope (Subprogram : Symbol;
                                  Scope      : Scopes) return Boolean
      --# global in Dict;
   is

      Region : Symbol;
      Found  : Boolean;

      --------------------------------------------------------------------------------

      function SearchRenamingDeclarations (Subprogram, Declarations : Symbol) return Boolean
         --# global in Dict;
      is
         Current : Symbol;
      begin

         Current := Declarations;

         loop
            exit when Current = NullSymbol;
            exit when RawDict.GetDeclarationItem (Current) = Subprogram;
            Current := RawDict.GetNextDeclaration (Current);
         end loop;

         return Current /= NullSymbol;

      end SearchRenamingDeclarations;

      --------------------------------------------------------------------------------

      function IsRenamedInThisPackage (Subprogram : Symbol; Scope : Scopes) return Boolean
         --# global in Dict;
      is

         ThisPackage : Symbol;
         Found       : Boolean;

         --------------------------------------------------------------------------------

         function IsRenamedInThisPackageSpecification (Subprogram, ThisPackage : Symbol) return Boolean
            --# global in Dict;
         is
         begin
            return SearchRenamingDeclarations (Subprogram,
                                               RawDict.GetPackageVisibleRenamingDeclarations (ThisPackage));
         end IsRenamedInThisPackageSpecification;

         --------------------------------------------------------------------------------

         function IsRenamedInThisPackageBody (Subprogram, ThisPackage : Symbol) return Boolean
            --# global in Dict;
         is
         begin
            return SearchRenamingDeclarations (Subprogram,
                                               RawDict.GetPackageLocalRenamingDeclarations (ThisPackage));
         end IsRenamedInThisPackageBody;

         --------------------------------------------------------------------------------

      begin

         ThisPackage := GetRegion (Scope);

         case Scope.TypeOfScope is
            when Visible | Privat =>   --583
               Found := IsRenamedInThisPackageSpecification (Subprogram, ThisPackage);
            when Local =>
               Found := IsRenamedInThisPackageBody (Subprogram, ThisPackage) or else
                  IsRenamedInThisPackageSpecification (Subprogram, ThisPackage);
         end case;

         return Found;

      end IsRenamedInThisPackage;

      --------------------------------------------------------------------------------

      function IsRenamedInThisSubprogram (Subprogram, ThisSubprogram : Symbol) return Boolean
         --# global in Dict;
      is
      begin
         return SearchRenamingDeclarations (Subprogram,
                                            RawDict.GetSubprogramRenamingDeclarations (ThisSubprogram));
      end IsRenamedInThisSubprogram;

      --------------------------------------------------------------------------------

   begin

      Region := GetRegion (Scope);

      case RawDict.GetSymbolDiscriminant (Region) is
         when PackageSymbol =>
            Found := IsRenamedInThisPackage (Subprogram, Scope);
         when SubprogramSymbol =>
            Found := IsRenamedInThisSubprogram (Subprogram, Region);
         when others =>
            Found := False;
      end case;

      return Found;

   end IsRenamedInThisScope;

   --------------------------------------------------------------------------------

begin

   Current := Scope;

   loop
      Found := IsRenamedInThisScope (Subprogram, Current);
      Region := GetRegion (Current);
      exit when Found;
      exit when IsPackage (Region);
      exit when IsMainProgram (Region);
      Current := GetEnclosingScope (Current);
   end loop;

   return Found;

end IsRenamed;
