-- $Id: dictionary-isimport.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function IsImport (Abstraction  : Abstractions;
                   TheProcedure : Symbol;
                   Variable     : Symbol) return Boolean
is

   --------------------------------------------------------------------------------

   function IsImportedParameter (Abstraction             : Abstractions;
                                 TheProcedure, Parameter : Symbol) return Boolean
   --# global in Dict;
   is
   begin
      return IsFormalParameter (TheProcedure, Parameter) and then
         RawDict.GetSubprogramParameterImported (Abstraction, Parameter);
   end IsImportedParameter;

   --------------------------------------------------------------------------------

   function IsImportedVariable (Abstraction  : Abstractions;
                                TheProcedure : Symbol;
                                Variable     : Symbol) return Boolean
   --# global in Dict;
   is
      Result         : Boolean;
      GlobalVariable : Symbol;
   begin

      -- allow use with task type as well as procedure
      if IsSubprogram (TheProcedure) then
         GlobalVariable := RawDict.GetSubprogramFirstGlobalVariable (Abstraction,
                                                                     TheProcedure);
      else
         GlobalVariable := RawDict.GetTaskTypeFirstGlobalVariable (Abstraction,
                                                                   TheProcedure);
      end if;

      loop
         if GlobalVariable = NullSymbol then
            Result := False;
            exit;
         end if;
         if RawDict.GetGlobalVariableVariable (GlobalVariable) = Variable then
            Result := RawDict.GetGlobalVariableImported (GlobalVariable);
            exit;
         end if;
         GlobalVariable := RawDict.GetNextGlobalVariable (GlobalVariable);
      end loop;

      return Result;

   end IsImportedVariable;

   --------------------------------------------------------------------------------

begin
   return IsImportedParameter (Abstraction, TheProcedure, Variable) or else
      IsImportedVariable (Abstraction, TheProcedure, Variable);
end IsImport;
