-- $Id: dictionary-getsubprogramcontrollingtype.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function GetSubprogramControllingType (Subprogram  : Symbol) return Symbol
is
   TheControllingType : Symbol;

   procedure OperationCanBeInherited (TheOpSym      : in     Symbol;
                                      TheTaggedType :    out Symbol)
   --# global in Dict;
   --# derives TheTaggedType from Dict,
   --#                            TheOpSym;
   is
      It          : Iterator;
      CurrentType : Symbol;

      function IsLocallyDeclared (TheType : Symbol) return Boolean
      --# global in Dict;
      --#        in TheOpSym;
      is
      begin
         return GetRegion (GetScope (TheType)) = GetRegion (GetScope (TheOpSym));
      end IsLocallyDeclared;

   begin
      TheTaggedType := NullSymbol; -- default
      -- a subprogram is suitable for inheritance if it has a parameter
      -- of a tagged type declared in the same package
      It := FirstSubprogramParameter (TheOpSym);
      while not IsNullIterator (It) loop
         CurrentType := GetType (CurrentSymbol (It));
         if TypeIsTagged (CurrentType) and then IsLocallyDeclared (CurrentType) then
            TheTaggedType := CurrentType;
            exit;
         end if;
         It := NextSymbol (It);
      end loop;
   end OperationCanBeInherited;

begin -- SearchForInheritedOperations
   OperationCanBeInherited (Subprogram,
                              -- to get
                            TheControllingType);
   return TheControllingType;
end GetSubprogramControllingType;
