-- $Id: dictionary-getscalarattributetype.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function GetScalarAttributeType (Name     : LexTokenManager.Lex_String;
                                 TypeMark : Symbol) return Symbol
is

   Result : Symbol;

   --------------------------------------------------------------------------------

   function GetRangeAttributeType (TypeMark : Symbol) return Symbol
      --# global in Dict;
   is
      Result : Symbol;
   begin

      if TypeIsArray (TypeMark) then
         Result := GetArrayIndex (TypeMark, 1);
      else
         Result := TypeMark;
      end if;

      return Result;

   end GetRangeAttributeType;

   --------------------------------------------------------------------------------

begin

   if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                           Lex_Str2 => LexTokenManager.Aft_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Digits_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Emax_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Fore_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Machine_Emax_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Machine_Emin_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Machine_Mantissa_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Machine_Radix_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Mantissa_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Pos_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Safe_Emax_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Size_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Model_Emin_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Model_Mantissa_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Model_Emin_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Modulus_Token) = LexTokenManager.Str_Eq then
      Result := GetUniversalIntegerType;

   elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Delta_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Epsilon_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Large_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Safe_Large_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Safe_Small_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Small_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Model_Epsilon_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Model_Small_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Safe_First_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Safe_Last_Token) = LexTokenManager.Str_Eq then
      Result := GetUniversalRealType;

   elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq then
      Result := GetRangeAttributeType (TypeMark);

   elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Machine_Overflows_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Machine_Rounds_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Denorm_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Signed_Zeros_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Valid_Token) = LexTokenManager.Str_Eq then
      Result := GetPredefinedBooleanType;

   elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Pred_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Succ_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Val_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Min_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Max_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Tail_Token) = LexTokenManager.Str_Eq or else   -- 'Tail   is a proof attribute
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Append_Token) = LexTokenManager.Str_Eq or else -- 'Append is a proof attribute
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Ceiling_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Mod_Token) = LexTokenManager.Str_Eq or else
     LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                          Lex_Str2 => LexTokenManager.Floor_Token) = LexTokenManager.Str_Eq then
      Result := GetRootType (TypeMark);

   elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Access_Token) = LexTokenManager.Str_Eq then
      Result := GetAccess (TypeMark);

   else
      Result := NullSymbol;
   end if;

   return Result;

end GetScalarAttributeType;
