-- $Id: dictionary-firstgenericformalparameter.adb 11354 2008-10-06 17:02:56Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
function FirstGenericFormalParameter (TheGeneric : Symbol) return Iterator
is

   FormalParameters : Iterator := NullIterator;
   -- initialization strictly not needed, fatal error occurs if attempt to
   -- return an undefined value occurs


   --------------------------------------------------------------------------------

   function FirstGenericFormalSubprogramParameter (TheGeneric : Symbol) return Iterator
      --# global in Dict;
   is
      TheGenericParameter  : Symbol;
      FormalParameters     : Iterator;
   begin

      TheGenericParameter := RawDict.GetSubprogramFirstGenericParameter (TheGeneric);

      if TheGenericParameter = NullSymbol then
         FormalParameters := NullIterator;
      else
         FormalParameters := Iterator'(GenericFormalParameterIterator,
                                       IsAbstract,
                                       TheGenericParameter,
                                       NullSymbol);
      end if;

      return FormalParameters;

   end FirstGenericFormalSubprogramParameter;

   --------------------------------------------------------------------------------

   function FirstGenericFormalPackageParameter (TheGeneric : Symbol) return Iterator
      --# global in Dict;
   is
      TheGenericParameter  : Symbol;
      FormalParameters     : Iterator;
   begin

      TheGenericParameter := RawDict.GetPackageFirstGenericParameter (TheGeneric);

      if TheGenericParameter = NullSymbol then
         FormalParameters := NullIterator;
      else
         FormalParameters := Iterator'(GenericFormalParameterIterator,
                                       IsAbstract,
                                       TheGenericParameter,
                                       NullSymbol);
      end if;

      return FormalParameters;

   end FirstGenericFormalPackageParameter;

   --------------------------------------------------------------------------------

begin
   if IsGenericSubprogram (TheGeneric) then
      FormalParameters := FirstGenericFormalSubprogramParameter (TheGeneric);
   elsif IsGenericPackage (TheGeneric) then
      FormalParameters := FirstGenericFormalPackageParameter (TheGeneric);
   else
      SystemErrors.FatalError (SystemErrors.PreconditionFailure,
                               "Wrong unit kind in FirstGenericFormalParameter");
   end if;
   return FormalParameters;
end FirstGenericFormalParameter;
