-- $Id: dictionary-attributeisvisiblebutobselete.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

----------------------------------------------------------------------------------------
-- If more attributes need to be added as obselete, it is recommended to follow
-- the structure of AttributeIsVisible, the skeleton of which is present here.


separate (Dictionary)

function AttributeIsVisibleButObselete (Name     : LexTokenManager.Lex_String;
                                        Prefix   : PrefixSort;
                                        TypeMark : Symbol;
                                        Scope    : Scopes) return Boolean
is

   Result : Boolean;

   --------------------------------------------------------------------------------
   -- Case analysis here is derived from AARM A.5.3 (72.d - 72.f) and
   -- AARM A.5.4 (4.a - 4.c)
   --------------------------------------------------------------------------------
   function TypeAttributeIsVisibleButObselete95 (Name     : LexTokenManager.Lex_String;
                                                 TypeMark : Symbol) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Safe_Emax_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Emax_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Small_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Epsilon_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Mantissa_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Large_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Small_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Large_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);

      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisibleButObselete95;

   --------------------------------------------------------------------------------

   function TypeAttributeIsVisibleButObselete (Name     : LexTokenManager.Lex_String;
                                               TypeMark : Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin
      case CommandLineData.Content.LanguageProfile is

         when CommandLineData.SPARK83 =>
            Result := False; -- Currently none such handled

         when CommandLineData.SPARK95 |
           CommandLineData.SPARK2005 =>

            -- Same in SPARK2005 and SPARK95, so...
            Result := TypeAttributeIsVisibleButObselete95 (Name, TypeMark);
      end case;

      return Result;
   end TypeAttributeIsVisibleButObselete;

   --------------------------------------------------------------------------------

begin
   SystemErrors.RTAssert (IsTypeMark (TypeMark) or else IsUnknownTypeMark (TypeMark),
                          SystemErrors.PreconditionFailure,
                          "In call to AttributeIsVisibleButObselete");

   if TypeIsPrivateHere (TypeMark, Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := TypeAttributeIsVisibleButObselete (Name, TypeMark);
         when ABaseType =>
            Result := False; -- Currently none such handled
         when AnObject =>
            Result := False; -- Currently none such handled
      end case;
   end if;

   return Result;

end AttributeIsVisibleButObselete;
