-- $Id: dictionary-attributeisvisible.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================



with CommandLineData;
separate (Dictionary)
function AttributeIsVisible (Name     : LexTokenManager.Lex_String;
                             Prefix   : PrefixSort;
                             TypeMark : Symbol;
                             Scope    : Scopes) return Boolean
is

   Result : Boolean;

   --------------------------------------------------------------------------------

   function TypeAttributeIsVisible83 (Name     : LexTokenManager.Lex_String;
                                      TypeMark : Symbol) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Aft_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Delta_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Fore_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsFixedPoint (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Size_Token) = LexTokenManager.Str_Eq then
         Result := True;
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Digits_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Emax_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Epsilon_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Emax_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Emin_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Mantissa_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Radix_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Emax_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq then
         if TypeIsScalar (TypeMark) then
            Result := True;
         elsif TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Large_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Overflows_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Rounds_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Mantissa_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Large_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Small_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Small_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq then
         if TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark) or else
              IsSubtype (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Pos_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Pred_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Succ_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Val_Token) = LexTokenManager.Str_Eq then
         if TypeIsDiscrete (TypeMark) then
            Result := not TypeIsBoolean (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;
      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisible83;

   --------------------------------------------------------------------------------


   function TypeAttributeIsVisible95 (Name     : LexTokenManager.Lex_String;
                                      TypeMark : Symbol) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Aft_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Delta_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Fore_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsFixedPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Size_Token) = LexTokenManager.Str_Eq then
         Result := True;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Digits_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Emax_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Emin_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Mantissa_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Denorm_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Model_Emin_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Model_Epsilon_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Model_Mantissa_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Model_Small_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_First_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Last_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Signed_Zeros_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Floor_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Ceiling_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Emax_Token) = LexTokenManager.Str_Eq or else -- Obsolete but implementation-defined in SPARK95
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Emax_Token) = LexTokenManager.Str_Eq or else -- Ditto
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Epsilon_Token) = LexTokenManager.Str_Eq then -- Ditto
         Result := TypeIsFloatingPoint (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq then
         if TypeIsScalar (TypeMark) then
            Result := True;
         elsif TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Machine_Overflows_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Rounds_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Machine_Radix_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Large_Token) = LexTokenManager.Str_Eq or else -- Obsolete but implementation-defined in SPARK95
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Mantissa_Token) = LexTokenManager.Str_Eq or else -- Ditto
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Large_Token) = LexTokenManager.Str_Eq or else -- Ditto
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Safe_Small_Token) = LexTokenManager.Str_Eq or else -- Ditto
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Small_Token) = LexTokenManager.Str_Eq then
         -- Obsolete but implementation-defined
         -- for floating-point types in SPARK95.
         -- OK for fixed-point types.
         Result := TypeIsReal (TypeMark) or else TypeIsUnknown (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq then
         if TypeIsArray (TypeMark) then
            Result := ArrayTypeIsConstrained (TypeMark) or else
              IsSubtype (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Pos_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Pred_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Succ_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Val_Token) = LexTokenManager.Str_Eq then
         if TypeIsDiscrete (TypeMark) then
            Result := not TypeIsBoolean (TypeMark);
         else
            Result := TypeIsUnknown (TypeMark);
         end if;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Component_Size_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsArray (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Min_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Max_Token) = LexTokenManager.Str_Eq then
         Result := (TypeIsScalar (TypeMark) and then
                      not TypeIsBoolean (TypeMark)) or else TypeIsUnknown (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Modulus_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsModular (TypeMark) or else TypeIsUnknown (TypeMark);

      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisible95;

   function TypeAttributeIsVisible2005 (Name     : LexTokenManager.Lex_String;
                                        TypeMark : Symbol) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Mod_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsModular (TypeMark);
      else
         Result := False;
      end if;

      return Result;

   end TypeAttributeIsVisible2005;
   --------------------------------------------------------------------------------

   function TypeAttributeIsVisible (Name     : LexTokenManager.Lex_String;
                                    TypeMark : Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin
      case CommandLineData.Content.LanguageProfile is

         when CommandLineData.SPARK83 =>

            Result := TypeAttributeIsVisible83 (Name, TypeMark);

         when CommandLineData.SPARK95 =>

            Result := TypeAttributeIsVisible95 (Name, TypeMark);

         when CommandLineData.SPARK2005 =>

            Result := TypeAttributeIsVisible95 (Name, TypeMark) or
              TypeAttributeIsVisible2005 (Name, TypeMark);

      end case;

      return Result;
   end TypeAttributeIsVisible;

   -------------------------------------------------------------------------------

   function BaseAttributeIsVisible (Name     : LexTokenManager.Lex_String;
                                    TypeMark : Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if TypeAttributeIsVisible (Name, TypeMark) then
         if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq then
            Result := not TypeIsArray (TypeMark);
         elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                    Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
           LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq then
            Result := False;
         else
            Result := True;
         end if;
      else
         Result := False;
      end if;

      return Result;

   end BaseAttributeIsVisible;

   --------------------------------------------------------------------------------

   function ObjectAttributeIsVisible83 (Name     : LexTokenManager.Lex_String;
                                        TypeMark : Symbol) return Boolean
   --# global in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Size_Token) = LexTokenManager.Str_Eq then
         Result := True;
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsArray (TypeMark);
      else
         Result := False;
      end if;

      return Result;

   end ObjectAttributeIsVisible83;

   --------------------------------------------------------------------------------

   function ObjectAttributeIsVisible95 (Name     : LexTokenManager.Lex_String;
                                        TypeMark : Symbol) return Boolean
   --# global in CommandLineData.Content;
   --#        in Dict;
   --#        in LexTokenManager.State;
   is
      Result : Boolean;
   begin

      if LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                              Lex_Str2 => LexTokenManager.Size_Token) = LexTokenManager.Str_Eq then
         Result := True;

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.First_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Last_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Length_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Range_Token) = LexTokenManager.Str_Eq or else
        LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                             Lex_Str2 => LexTokenManager.Component_Size_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsArray (TypeMark);

         -- Support for 'Valid in SPARK95
      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Valid_Token) = LexTokenManager.Str_Eq then
         -- LRM 13.9.2 (2) says 'Valid is only allowed for a prefix that
         -- denotes a scalar type.
         Result := TypeIsScalar (TypeMark);

      elsif LexTokenManager.Lex_String_Case_Insensitive_Compare (Lex_Str1 => Name,
                                                                 Lex_Str2 => LexTokenManager.Access_Token) = LexTokenManager.Str_Eq then
         Result := TypeIsProtected (TypeMark) and then
           CommandLineData.RavenscarSelected;
      else
         Result := False;
      end if;

      return Result;

   end ObjectAttributeIsVisible95;

   --------------------------------------------------------------------------------

begin
   SystemErrors.RTAssert (IsTypeMark (TypeMark) or else IsUnknownTypeMark (TypeMark),
                          SystemErrors.PreconditionFailure,
                          "In call to AttributeIsVisible");

   if TypeIsPrivateHere (TypeMark, Scope) then
      Result := False;
   else
      case Prefix is
         when AType =>
            Result := TypeAttributeIsVisible (Name, TypeMark);
         when ABaseType =>
            Result := BaseAttributeIsVisible (Name, TypeMark);
         when AnObject =>

            case CommandLineData.Content.LanguageProfile is

               when CommandLineData.SPARK83 =>

                  Result := ObjectAttributeIsVisible83 (Name, TypeMark);

               when CommandLineData.SPARK95 |
                 CommandLineData.SPARK2005 =>

                  -- Object attributes in SPARK2005 are currently the same
                  -- as those of SPARK95, so...
                  Result := ObjectAttributeIsVisible95 (Name, TypeMark);
            end case;
      end case;
   end if;

   return Result;

end AttributeIsVisible;
