-- $Id: dictionary-addrecordsubcomponent.adb 13645 2009-06-25 13:57:33Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddRecordSubcomponent (Prefix       : in     Symbol;
                                 Component    : in     Symbol;
                                 Comp_Unit    : in     ContextManager.UnitDescriptors;
                                 Subcomponent :    out Symbol)
is
   NewSubcomponent,
   CurrentSubcomponent,
   NextSubcomponent     : Symbol;
   ValidState           : Boolean;

   procedure AddFirstSubcomponent (Prefix       : in     Symbol;
                                   Component    : in     Symbol;
                                   Comp_Unit    : in     ContextManager.UnitDescriptors;
                                   Subcomponent :    out Symbol)
   --# global in     ValidState;
   --#        in out Dict;
   --# derives Dict         from *,
   --#                           Component,
   --#                           Comp_Unit,
   --#                           Prefix,
   --#                           ValidState &
   --#         Subcomponent from Component,
   --#                           Comp_Unit,
   --#                           Dict;
   is
      NewSubcomponent : Symbol;

   begin  --AddFirstSubcomponent
      RawDict.CreateSubcomponent (Prefix,
                                  Component,
                                  Comp_Unit,
                                  RawDict.Get_Symbol_Location (Component),
                                    --to get
                                  NewSubcomponent);

      case RawDict.GetSymbolDiscriminant (Prefix) is
         when VariableSymbol =>
            RawDict.SetVariableSubComponents (Prefix, NewSubcomponent);
         when SubprogramParameterSymbol =>
            RawDict.SetSubprogramParameterSubComponents (Prefix, NewSubcomponent);
         when others =>
            RawDict.SetSubcomponentSubcomponents (Prefix, NewSubcomponent);
      end case;
      SetSubcomponentMarkedValid (NewSubcomponent, ValidState);
      Subcomponent := NewSubcomponent;

   end AddFirstSubcomponent;

   ------------------

begin --AddRecordSubcomponent
   case RawDict.GetSymbolDiscriminant (Prefix) is
      when VariableSymbol =>
         CurrentSubcomponent := RawDict.GetVariableSubComponents (Prefix);
         ValidState := VariableIsMarkedValid (Prefix);
      when SubprogramParameterSymbol =>
         CurrentSubcomponent := RawDict.GetSubprogramParameterSubComponents (Prefix);
         ValidState := True;
      when SubcomponentSymbol =>
         CurrentSubcomponent := RawDict.GetSubcomponentSubcomponents (Prefix);
         ValidState := SubcomponentIsMarkedValid (Prefix);
      when others =>
         CurrentSubcomponent := NullSymbol;
         ValidState := False;
         SystemErrors.RTAssert (False,
                         SystemErrors.AssertionFailure,
                         "Unexpected case in AddRecordSubcomponent");
   end case;

   if CurrentSubcomponent = NullSymbol then
      -- no subcomponents at all
      AddFirstSubcomponent (Prefix       => Prefix,
                            Component    => Component,
                            Comp_Unit    => Comp_Unit,
                            --to get
                            Subcomponent => Subcomponent);

   else -- at least one subcomponent already present
      loop
         if RawDict.GetSubcomponentComponent (CurrentSubcomponent) = Component then
            -- the one we are seeking to add is already present
            Subcomponent := CurrentSubcomponent;
            exit;
         end if;

         NextSubcomponent := RawDict.GetNextSubcomponent (CurrentSubcomponent);

         if NextSubcomponent = NullSymbol then
            -- checked all subcomponents and didn't find the one we want so add it
            RawDict.CreateSubcomponent (Prefix,
                                        Component,
                                        Comp_Unit,
                                        RawDict.Get_Symbol_Location (CurrentSubcomponent),
                                          --to get
                                        NewSubcomponent);
            RawDict.SetNextSubcomponent (CurrentSubcomponent, NewSubcomponent);
            SetSubcomponentMarkedValid (NewSubcomponent, ValidState);
            Subcomponent := NewSubcomponent;
            exit;
         end if;

         CurrentSubcomponent := NextSubcomponent;
      end loop;
   end if;

end AddRecordSubcomponent;
