-- $Id: dictionary-adddependency.adb 13645 2009-06-25 13:57:33Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddDependency (Abstraction     : in Abstractions;
                         Comp_Unit       : in ContextManager.UnitDescriptors;
                         TheProcedure    : in Symbol;
                         TheExport       : in Symbol;
                         TheImport       : in Symbol;
                         ImportReference : in Location)
is

   Dependency : Symbol;

   --------------------------------------------------------------------------------

   procedure AddSubprogramParameterDependency (Abstraction : in Abstractions;
                                               TheExport   : in Symbol;
                                               Dependency  : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Abstraction,
      --#                   Dependency,
      --#                   TheExport;
   is
   begin
      RawDict.SetNextDependency (Dependency,
                                 RawDict.GetSubprogramParameterDependencies (Abstraction, TheExport));
      RawDict.SetSubprogramParameterDependencies (Abstraction, TheExport, Dependency);
   end AddSubprogramParameterDependency;

   --------------------------------------------------------------------------------

   procedure AddGlobalVariableDependency (Abstraction  : in Abstractions;
                                          TheProcedure : in Symbol;
                                          TheExport    : in Symbol;
                                          Dependency   : in Symbol)
      --# global in out Dict;
      --# derives Dict from *,
      --#                   Abstraction,
      --#                   Dependency,
      --#                   TheExport,
      --#                   TheProcedure;
   is
      GlobalVariable : Symbol;
   begin
      GlobalVariable := GetGlobalVariable (Abstraction, TheProcedure, TheExport);
      RawDict.SetNextDependency (Dependency,
                                 RawDict.GetGlobalVariableDependencies (Abstraction, GlobalVariable));
      RawDict.SetGlobalVariableDependencies (Abstraction, GlobalVariable, Dependency);
   end AddGlobalVariableDependency;

   --------------------------------------------------------------------------------

begin

   RawDict.CreateDependency (TheImport  => TheImport,
                             Comp_Unit  => Comp_Unit,
                             Loc        => ImportReference.StartPosition,
                             Dependency => Dependency);

   if IsFormalParameter (TheProcedure, TheExport) then
      AddSubprogramParameterDependency (Abstraction, TheExport, Dependency);
   else
      AddGlobalVariableDependency (Abstraction, TheProcedure, TheExport, Dependency);
   end if;

   ForceImport (Abstraction, TheProcedure, TheImport, ImportReference);

end AddDependency;
