-- $Id: dictionary-addbodystub.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Dictionary)
procedure AddBodyStub (CompilationUnit : in Symbol;
                       Comp_Unit       : in ContextManager.UnitDescriptors;
                       BodyStub        : in Location)
is

   Scope       : Scopes;
   Declaration : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteBodyStub (CompilationUnit : in Symbol;
                            BodyStub        : in Location)
      --# global in     Dict;
      --#        in     LexTokenManager.State;
      --#        in out SPARK_IO.File_Sys;
      --# derives SPARK_IO.File_Sys from *,
      --#                                BodyStub,
      --#                                CompilationUnit,
      --#                                Dict,
      --#                                LexTokenManager.State;
   is
   begin
      if SPARK_IO.Is_Open (Dict.TemporaryFile) then
         WriteString (Dict.TemporaryFile, "body stub of ");
         WriteName (Dict.TemporaryFile, CompilationUnit);
         WriteString (Dict.TemporaryFile, " is at ");
         WriteLocation (Dict.TemporaryFile, BodyStub);
         WriteLine (Dict.TemporaryFile, " ;");
      end if;
   end WriteBodyStub;

   --------------------------------------------------------------------------------

begin

   Scope := GetScope (CompilationUnit);

   if IsVisibleScope (Scope) or else
      IsPrivateScope (Scope) then
      Scope := GetLocalScope (Scope);
   end if;

   AddDeclaration (Item        => CompilationUnit,
                   Comp_Unit   => Comp_Unit,
                   Loc         => BodyStub,
                   Scope       => Scope,
                   Context     => ProgramContext,
                   Declaration => Declaration);

   case RawDict.GetSymbolDiscriminant (CompilationUnit) is
      when PackageSymbol =>
         RawDict.SetPackageBody (CompilationUnit, Declaration);
      when TypeSymbol =>
         if RawDict.GetTypeDiscriminant (CompilationUnit) = ProtectedType then
            RawDict.SetProtectedTypeBody (CompilationUnit, Declaration);
         elsif RawDict.GetTypeDiscriminant (CompilationUnit) = TaskType then
            RawDict.SetTaskTypeBody (CompilationUnit, Declaration);
         end if;
      when others =>
         RawDict.SetSubprogramBody (CompilationUnit, Declaration);
   end case;

   WriteBodyStub (CompilationUnit, BodyStub);

end AddBodyStub;
