-- $Id: declarations-outputdeclarations-printdeclarations-printruleheader.adb 15520 2010-01-07 12:53:45Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


separate (Declarations.OutputDeclarations.PrintDeclarations)
procedure PrintRuleHeader (WriteRules : in Boolean;
                           RuleFile   : in SPARK_IO.File_Type)
is
   Ok : Boolean;

   procedure SetUpFamilyName
   --# global in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     Scope;
   --#           out RuleFamilyName;
   --# derives RuleFamilyName from Dictionary.Dict,
   --#                             LexTokenManager.State,
   --#                             Scope;
   is
      MaxNameLen : constant EStrings.Lengths := 12;
   begin
      RuleFamilyName := LexTokenManager.Lex_String_To_String
        (Lex_Str => Dictionary.GetSimpleName (Dictionary.GetRegion (Scope)));
      if EStrings.Get_Length (E_Str => RuleFamilyName) > MaxNameLen then
         RuleFamilyName := EStrings.Section (E_Str     => RuleFamilyName,
                                             Start_Pos => 1,
                                             Length    => MaxNameLen);
      end if;
      RuleFamilyName := EStrings.Lower_Case (E_Str => RuleFamilyName);
      EStrings.Append_String (E_Str => RuleFamilyName,
                              Str   => "_rules");
   end SetUpFamilyName;

begin --PrintRuleHeader

   --# accept Flow, 10, Ok, "Expected ineffective assignment to Ok";
   Lists.New_List (Heap     => LHeap,
                   The_List => TypeList,
                   Ok       => Ok);
   --# end accept;

   SetUpFamilyName;
   RuleCounter := 0;

   if WriteRules then

      SPARK_IO.Put_String (RuleFile, "rule_family ", 0);
      EStrings.Put_String (File  => RuleFile,
                           E_Str => RuleFamilyName);
      SPARK_IO.Put_Line (RuleFile, ":", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X      requires [X:any] &", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X <= Y requires [X:ire, Y:ire] &", 0);

      SPARK_IO.Set_Col (RuleFile, 2 * Indent);
      SPARK_IO.Put_Line (RuleFile, "X >= Y requires [X:ire, Y:ire].", 0);
      SPARK_IO.New_Line (RuleFile, 1);

   end if;
   --# accept Flow, 33, Ok, "Expected Ok to be neither referenced nor exported";
end PrintRuleHeader;
