-- $Id: cstacks.ads 12696 2009-03-12 13:14:05Z Rod Chapman $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with Cells,
     ExaminerConstants;

use type Cells.Cell_Kind;

--# inherit Cells,
--#         ExaminerConstants,
--#         SPARK_IO,
--#         Statistics;

package CStacks
is

   ---------------------------------------------------------------
   -- A Stack of Cells.Cell values, built within a Cell Heap.
   ---------------------------------------------------------------
   type Stack is private;

   function IsEmpty (S : Stack) return Boolean;

   function Top (Heap : Cells.Heap_Record;
                 S    : Stack) return Cells.Cell;
   --# pre not IsEmpty(S);

   procedure CreateStack (S : out Stack);
   --# derives S from ;
   --# post IsEmpty (S);

   procedure Pop (Heap : in out Cells.Heap_Record;
                  S    : in out Stack);
   --# derives Heap,
   --#         S    from Heap,
   --#                   S;
   --# pre not IsEmpty(S);

   -- New procedure (shorthand for Top followed by Pop)
   procedure PopOff (Heap : in out Cells.Heap_Record;
                     S    : in out Stack;
                     C    :    out Cells.Cell);
   --# derives C,
   --#         Heap,
   --#         S    from Heap,
   --#                   S;
   --# pre not IsEmpty(S);


   procedure Push (Heap     : in out Cells.Heap_Record;
                   CellName : in     Cells.Cell;
                   S        : in out Stack);
   --# global in out Statistics.TableUsage;
   --# derives Heap                  from *,
   --#                                    CellName,
   --#                                    S &
   --#         S                     from Heap &
   --#         Statistics.TableUsage from *,
   --#                                    Heap;
   --# post not IsEmpty (S);

   -- Leave Stack unchanged but return a "new stack" that starts one item lower
   function  NonDestructivePop (Heap : Cells.Heap_Record;
                                S    : Stack) return Stack;

   -- New function which peeks down stack to find kind the first
   -- IncompleteAggregate cell.  Used in Build[Annotation]ExpnDAG when processing aggregates.
   function FindAggregateCell (Heap : Cells.Heap_Record;
                               S    : Stack) return Cells.Cell;
   --# return M => Cells.Get_Kind (Heap, M) = Cells.Incomplete_Aggregate;
   -- AND M is the FIRST such element in S.


   -- New function which peeks down stack to find kind the first
   -- AggregateCounter cell.  Used in Build[Annotation]ExpnDAG when processing aggregates.
   function FindAggregateCounter (Heap : Cells.Heap_Record;
                                  S    : Stack) return Cells.Cell;
   --# return M => Cells.Get_Kind (Heap, M) = Cells.Aggregate_Counter;
   -- AND M is the FIRST such element in S.

private
   -- A Stack is the Cell Number of the top of the stack
   type Stack is range 0 .. ExaminerConstants.VCGCellListLength;
   --# assert Stack'Base is Integer;

end CStacks;
