-- $Id: contextmanager.ads 13656 2009-06-26 09:52:01Z Bill Ellis $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with ExaminerConstants;

--# inherit ExaminerConstants;

package ContextManager
is

   type UnitTypes is (MainProgram,
                      PackageSpecification, -- use this one when we have a package body and know we need spec
                      PackageBody,
                      SubUnit,
                      InterUnitPragma,
                      GenericDeclaration, -- use this one when we have a generic body and know we need spec
                      GenericPackageInstantiation,
                      GenericSubprogramBody,
                      InvalidUnit,
                        -- this one is for inherited items where we don't know which it is
                      PackageOrGenericDeclaration);

   type UnitTypeSets is array (UnitTypes) of Boolean;

   -- set of inheritable things (was previously only packages)
   InheritableItem : constant UnitTypeSets :=
     UnitTypeSets'(PackageSpecification => True,
                   GenericDeclaration => True,
                   others => False);

   PackageSpecificationSet : constant UnitTypeSets :=
     UnitTypeSets'(PackageSpecification => True,
                   others => False);

   -- this is for generic subprogram declarations, where we know that is what we want because we found a generic body
   GenericDeclarationSet : constant UnitTypeSets :=
     UnitTypeSets'(GenericDeclaration => True,
                   others => False);

   BodySet : constant UnitTypeSets :=
      UnitTypeSets'(MainProgram | PackageBody => True, others => False);

   SubUnitSet : constant UnitTypeSets :=
      UnitTypeSets'(SubUnit | PackageBody => True, others => False);

   type UnitDescriptors is private;
   type FileDescriptors is private;

   NullUnit : constant UnitDescriptors;
   NullFile : constant FileDescriptors;

   type UnitStatus is (NoUnitEntry, UnitCreated, UnitParsed,
                       UnitDeferred,
                       UnitAnalysed,
                       NoIndexFile,
                       NotInIndexFile,
                       CannotOpenFile,
                       UnableToLocate);

   subtype UnitNotFound is UnitStatus range NoIndexFile .. UnableToLocate;

   type FileStatus is (NoFileEntry, FileCreated, FileOpen,
                       FileEnd, UnableToOpen);

private

   type UnitDescriptors is range 0 .. ExaminerConstants.ContextManagerMaxUnits;
   --# assert UnitDescriptors'Base is Short_Integer; -- for GNAT

   type FileDescriptors is range 0 .. ExaminerConstants.ContextManagerMaxFiles;
   --# assert FileDescriptors'Base is Short_Integer; -- for GNAT

   NullUnit : constant UnitDescriptors := 0;
   NullFile : constant FileDescriptors := 0;

end ContextManager;
