-- $Id: contextmanager-ops.ads 15760 2010-01-25 13:18:18Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================

with LexTokenLists;
with LexTokenManager;
with ErrorHandler;
with EStrings;
with SparkLex;
with STree;
with SPARK_IO;

use type LexTokenLists.Lists;
use type LexTokenManager.Str_Comp_Result;
use type STree.Iterator;

--# inherit CommandLineData,
--#         ContextManager,
--#         Dictionary,
--#         ErrorHandler,
--#         EStrings,
--#         ExaminerConstants,
--#         IndexManager,
--#         LexTokenLists,
--#         LexTokenManager,
--#         SparkLex,
--#         SPARK_IO,
--#         SPSymbols,
--#         STree,
--#         SystemErrors;

package ContextManager.Ops
--# own FileHeap  : FileHeaps;
--#     UnitHeap  : UnitHeaps;
--#     UnitStack : UnitStacks;
--# initializes FileHeap,
--#             UnitHeap,
--#             UnitStack;
is
   function CurrentUnit  return ContextManager.UnitDescriptors;
   --# global in UnitStack;
   function GetUnitStatus (Descriptor : ContextManager.UnitDescriptors) return ContextManager.UnitStatus;
   --# global in UnitHeap;
   procedure CreateUnitDescriptor (Descriptor : out ContextManager.UnitDescriptors);
   --# global in out UnitHeap;
   --# derives Descriptor,
   --#         UnitHeap   from UnitHeap;

   procedure SetFileDescriptor (UnitDescriptor : in ContextManager.UnitDescriptors;
                                FileDescriptor : in ContextManager.FileDescriptors);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       FileDescriptor,
   --#                       UnitDescriptor;

   procedure GetFileDescriptor (UnitDescriptor : in ContextManager.UnitDescriptors;
                                FileDescriptor : out ContextManager.FileDescriptors);
   --# global in UnitHeap;
   --# derives FileDescriptor from UnitDescriptor,
   --#                             UnitHeap;

   procedure SetUnitStatus (Descriptor : in ContextManager.UnitDescriptors;
                            Status     : in ContextManager.UnitStatus);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       Status;

   -- 051 -- Added following four subprograms
   procedure IncUnitCount (Descriptor : in ContextManager.FileDescriptors);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor;

   procedure GetUnitCount (Descriptor : in     ContextManager.FileDescriptors;
                           Count      :    out Natural);
   --# global in FileHeap;
   --# derives Count from Descriptor,
   --#                    FileHeap;

   function GetUnitNumber (Descriptor : ContextManager.UnitDescriptors) return Natural;
   --# global in UnitHeap;
   procedure SetUnitNumber (Descriptor : in ContextManager.UnitDescriptors;
                            Count      : in Natural);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Count,
   --#                       Descriptor;

   function GetFileStatus (Descriptor : ContextManager.FileDescriptors) return ContextManager.FileStatus;
   --# global in FileHeap;

   procedure SetVCG (Descriptor : in ContextManager.UnitDescriptors;
                     VCG        : in Boolean);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       VCG;

   procedure GetVCG (Descriptor : in     ContextManager.UnitDescriptors;
                     VCG        :    out Boolean);
   --# global in UnitHeap;
   --# derives VCG from Descriptor,
   --#                  UnitHeap;

   procedure GetUnitByName (UnitName    : in     LexTokenLists.Lists;
                            UnitTypeSet : in     ContextManager.UnitTypeSets;
                            Descriptor  :    out ContextManager.UnitDescriptors);
   --# global in LexTokenManager.State;
   --#        in UnitHeap;
   --# derives Descriptor from LexTokenManager.State,
   --#                         UnitHeap,
   --#                         UnitName,
   --#                         UnitTypeSet;

   procedure SetUnitName (Descriptor : in ContextManager.UnitDescriptors;
                          UnitName   : in LexTokenLists.Lists;
                          UnitType   : in ContextManager.UnitTypes);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       UnitName,
   --#                       UnitType;

   procedure GetUnitName (Descriptor : in     ContextManager.UnitDescriptors;
                          UnitName   :    out LexTokenLists.Lists;
                          UnitType   :    out ContextManager.UnitTypes);
   --# global in UnitHeap;
   --# derives UnitName,
   --#         UnitType from Descriptor,
   --#                       UnitHeap;

   procedure SetParseTree (Descriptor : in ContextManager.UnitDescriptors;
                           ParseTree  : in STree.SyntaxNode);
   --# global in     STree.Table;
   --#        in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       ParseTree,
   --#                       STree.Table;

   procedure GetParseTree (Descriptor : in     ContextManager.UnitDescriptors;
                           ParseTree  :    out STree.SyntaxNode);
   --# global in UnitHeap;
   --# derives ParseTree from Descriptor,
   --#                        UnitHeap;

   procedure MarkUnitInCycle (Descriptor : in ContextManager.UnitDescriptors);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor;

   function UnitInCycle (Descriptor : ContextManager.UnitDescriptors) return Boolean;
   --# global in UnitHeap;
   function FirstUnitDescriptor return ContextManager.UnitDescriptors;
   --# global in UnitHeap;
   function NextUnitDescriptor (Descriptor : ContextManager.UnitDescriptors)
                               return ContextManager.UnitDescriptors;
   --# global in UnitHeap;
   procedure PushUnit (Descriptor : in ContextManager.UnitDescriptors);
   --# global in out UnitStack;
   --# derives UnitStack from *,
   --#                        Descriptor;

   procedure PopUnit (Descriptor : out ContextManager.UnitDescriptors);
   --# global in out UnitStack;
   --# derives Descriptor,
   --#         UnitStack  from UnitStack;

   procedure CreateFileDescriptor (Descriptor : out ContextManager.FileDescriptors);
   --# global in out FileHeap;
   --# derives Descriptor,
   --#         FileHeap   from FileHeap;

   procedure SetSourceFileName (Descriptor     : in ContextManager.FileDescriptors;
                                SourceFileName : in LexTokenManager.Lex_String);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       SourceFileName;

   function GetSourceFileName (Descriptor : in ContextManager.FileDescriptors) return LexTokenManager.Lex_String;
   --# global in FileHeap;

   procedure SetSourceFile (Descriptor : in ContextManager.FileDescriptors;
                            SourceFile : in SPARK_IO.File_Type);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       SourceFile;

   procedure GetSourceFile (Descriptor : in     ContextManager.FileDescriptors;
                            SourceFile :    out SPARK_IO.File_Type);
   --# global in FileHeap;
   --# derives SourceFile from Descriptor,
   --#                         FileHeap;

   function ListingReqt (Descriptor : ContextManager.FileDescriptors) return Boolean;
   --# global in FileHeap;
   function FirstFileDescriptor return ContextManager.FileDescriptors;
   --# global in FileHeap;
   function NextFileDescriptor (Descriptor : ContextManager.FileDescriptors)
      return ContextManager.FileDescriptors;
   --# global in FileHeap;

   function GetFileByName (FileName : in LexTokenManager.Lex_String) return ContextManager.FileDescriptors;
   --# global in FileHeap;
   --#        in LexTokenManager.State;

   procedure SetFileStatus (Descriptor  : in ContextManager.FileDescriptors;
                            Status      : in ContextManager.FileStatus);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       Status;

   procedure SetListingReq (Descriptor : in ContextManager.FileDescriptors;
                            Req        : in Boolean);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       Req;

   procedure SetLineContext (Descriptor  : in ContextManager.FileDescriptors;
                             FileContext : in SparkLex.LineContext);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       FileContext;

   procedure GetLineContext (Descriptor  : in     ContextManager.FileDescriptors;
                             FileContext : out SparkLex.LineContext);
   --# global in FileHeap;
   --# derives FileContext from Descriptor,
   --#                          FileHeap;

   procedure SetErrorContext (Descriptor  : in ContextManager.FileDescriptors;
                              Context     : in ErrorHandler.ErrorContexts);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Context,
   --#                       Descriptor;

   procedure GetErrorContext (Descriptor  : in     ContextManager.FileDescriptors;
                              Context     :    out ErrorHandler.ErrorContexts);
   --# global in FileHeap;
   --# derives Context from Descriptor,
   --#                      FileHeap;

   procedure SetListingFileName (Descriptor      : in ContextManager.FileDescriptors;
                                 ListingFileName : in EStrings.T);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor,
   --#                       ListingFileName;

   procedure GetListingFileName (Descriptor      : in  ContextManager.FileDescriptors;
                                 ListingFileName : out EStrings.T);
   --# global in FileHeap;
   --# derives ListingFileName from Descriptor,
   --#                              FileHeap;

   procedure SetErrorsReported (Descriptor : in ContextManager.FileDescriptors);
   --# global in out FileHeap;
   --# derives FileHeap from *,
   --#                       Descriptor;

   function ErrorsReported (Descriptor : ContextManager.FileDescriptors) return Boolean;
   --# global in FileHeap;

   --  Find the compilation unit descriptor associated with the file
   --  descriptor (Descriptor). Each compilation unit has only one
   --  file but each file can contain many compilation units. This
   --  function must only be used for the SLI generation because, in
   --  the case of GNAT source code, each file has only one
   --  compilation unit.
   procedure Get_Unit (Descriptor      : in     ContextManager.FileDescriptors;
                       Unit_Descriptor :    out ContextManager.UnitDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     LexTokenManager.State;
   --#        in     STree.Table;
   --#        in     UnitHeap;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out SPARK_IO.File_Sys;
   --# derives ErrorHandler.ErrorContext,
   --#         SPARK_IO.File_Sys         from CommandLineData.Content,
   --#                                        Descriptor,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        LexTokenManager.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        UnitHeap &
   --#         Unit_Descriptor           from Descriptor,
   --#                                        UnitHeap;

   --  Get the parent of an Ada separate unit (Unit_Descriptor).
   procedure Get_Parent (Unit_Descriptor : in out ContextManager.UnitDescriptors);
   --# global in LexTokenManager.State;
   --#        in UnitHeap;
   --# derives Unit_Descriptor from *,
   --#                              LexTokenManager.State,
   --#                              UnitHeap;

   --  The procedure marks all the compilation units that are in the
   --  closure of the compilation unit associated with the file
   --  descriptor (Descriptor). Each compilation unit has only one
   --  file but each file can contain many compilation units. This
   --  function must only be used for the SLI generation because, in
   --  the case of GNAT source code, each file has only one
   --  compilation unit. This procedure must be called before the
   --  function In_Closure.
   procedure Dependency_Closure (Descriptor : in ContextManager.FileDescriptors);
   --# global in     CommandLineData.Content;
   --#        in     Dictionary.Dict;
   --#        in     STree.Table;
   --#        in out ErrorHandler.ErrorContext;
   --#        in out IndexManager.State;
   --#        in out LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --#        in out UnitHeap;
   --#           out IndexManager.LastChar;
   --# derives ErrorHandler.ErrorContext,
   --#         IndexManager.LastChar,
   --#         IndexManager.State,
   --#         LexTokenManager.State,
   --#         SPARK_IO.File_Sys,
   --#         UnitHeap                  from CommandLineData.Content,
   --#                                        Descriptor,
   --#                                        Dictionary.Dict,
   --#                                        ErrorHandler.ErrorContext,
   --#                                        IndexManager.State,
   --#                                        LexTokenManager.State,
   --#                                        SPARK_IO.File_Sys,
   --#                                        STree.Table,
   --#                                        UnitHeap;

   --  Return TRUE if the compilation unit descriptor (Descriptor) is
   --  in the closure of the compilation unit calculated by
   --  Dependency_Closure. The procedure Dependency_Closure must be
   --  called before this function.
   function In_Closure (Descriptor : in ContextManager.UnitDescriptors) return Boolean;
   --# global in UnitHeap;

   --  Set the line number of the "D ..." line (see D section of the
   --  ALI format).
   procedure Set_Line_Number (Descriptor  : in ContextManager.UnitDescriptors;
                              Line_Number : in Positive);
   --# global in out UnitHeap;
   --# derives UnitHeap from *,
   --#                       Descriptor,
   --#                       Line_Number;

   --  Get the line number of the "D ..." line (see D section of the
   --  ALI format).
   function Get_Line_Number (Descriptor  : in ContextManager.UnitDescriptors) return Natural;
   --# global in UnitHeap;

end ContextManager.Ops;
