-- $Id: adjustfdl_rws.adb 14620 2009-10-28 13:40:30Z spark $
--------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
--------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--==============================================================================


with SparkLex;
package body AdjustFDL_RWs
is
   procedure PossiblyAdjust (ExStr  : in out EStrings.T;
                             Prefix : in     EStrings.T)
   is
      TempStr : EStrings.T;
   begin
      if SparkLex.CheckFDL_RW (ExStr) then
         TempStr := Prefix;
         EStrings.Append_String (E_Str => TempStr,
                                 Str   => "__");
         EStrings.Append_Examiner_String (E_Str1 => TempStr,
                                          E_Str2 => ExStr);
         ExStr := TempStr;
      end if;
   end PossiblyAdjust;

end AdjustFDL_RWs;
