%  $Id: setflags.pro 16548 2010-03-23 17:10:24Z dean kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


/*** SET -- top-level predicate to set a flag to a particular value ***/
(set) :-
        (
           command_arg(flag, FLAG)
        ;
           prompt_user('Flag name? '),
           rread(FLAG)
        ),
        is_a_flag(FLAG, VALUETYPE),
        !,
        (
           command_arg(value, VALUE)
        ;
           prompt_user('New value? '),
           rread(VALUE)
        ),
        ok_value(VALUE, VALUETYPE),
        !,
        OLD =.. [FLAG, OLDVAL],                                 /* CFR045 */
        NEW =.. [FLAG, VALUE],
        !,
        retractall(OLD),
        asserta(NEW),
        !,
        (                                                       /* CFR045 */
           FLAG = command_logging,                              /* CFR045 */
           (                                                    /* CFR045 */
              VALUE = OLDVAL    /* so no change */              /* CFR045 */
           ;                                                    /* CFR045 */
              VALUE = off,                                      /* CFR045 */
              command_log_filename(CLG),                        /* CFR045 */
              tell(CLG),                                        /* CFR045 */
              told                                              /* CFR045 */
           ;                                                    /* CFR045 */
              VALUE = on,                                       /* CFR045 */
              command_log_filename(CLG),                        /* CFR045 */
              telling(NOW),                                     /* CFR045 */
              (
                 file_can_be_written(CLG)
              ;
                 \+ file_can_be_written(CLG),
                 write('Aborted: '),
                 print(CLG),
                 write(' cannot be written.'),
                 nl,
                 !,
                 close_all_streams,
                 halt
              ),
              tell(CLG),                                        /* CFR045 */
              write("set command_logging to on."),              /* CFR045 */
              nl,                                               /* CFR045 */
              telling(NOW),                                     /* CFR045 */
              tell(NOW)                                         /* CFR045 */
           )                                                    /* CFR045 */
        ;                                                       /* CFR045 */
           true                                                 /* CFR045 */
        ),                                                      /* CFR045 */
        !.


/*** SHOW -- top-level command to display current values of all flags ***/
show :-
        is_a_flag(FLAG, VALUETYPE),
        PREDICATE =.. [FLAG, VALUE],
        call(PREDICATE),
        print(FLAG),
        write(' := '),
        write_flag_value(VALUETYPE, VALUE),
        nl,
        fail.
show :- statistics, fail.
show.


write_flag_value(int_list/string, LIST) :-
        put_code(34), write_flag_string(LIST), put_code(34), !.
write_flag_value(_, VALUE) :- print(VALUE), !.


write_flag_string([H|T]) :- put_code(H), !, write_flag_string(T).
write_flag_string([]) :- !.
%###############################################################################
%END-OF-FILE
