%  $Id: loadsicstus.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


/* CONSULT CHECKER MODULES */

:- use_module('checker_ioutilities.pro').

:- include('sicstus.pro').

:- include('declar.pro').
:- include('portray.pro').
:- include('utilities.pro').
:- include('newvc.pro').
:- include('listthm.pro').
:- include('aritheval.pro').
:- include('replace2.pro').
:- include('repall.pro').                /* New for 1.2 */
:- include('standard.pro').
:- include('simp.pro').
:- include('infer2.pro').
:- include('inferenc2.pro').
:- include('records2.pro').                              /*** MODIFICATIONS ***/
:- include('subgoal.pro').
:- include('deduce.pro').
:- include('deduction.pro').


:- include('done3.pro').                                 /*** MODIFICATIONS ***/
:- include('cases2.pro').
:- include('contra.pro').
:- include('fwdch2.pro').
:- include('simplify.pro').
:- include('typecheck5.pro').
:- include('traverse.pro').              /* New for 1.2 */
:- include('semistan.pro').
:- include('prooflogs.pro').
:- include('newrules.pro').
:- include('loadvc5.pro').
:- include('quantif.pro').
:- include('induction.pro').
:- include('toplevel.pro').
:- include('setflags.pro').
:- include('help.pro').
:- include('rulefiles.pro').
:- include('getdcldat.pro').                     /* New for 1.2 */
:- include('initialise.pro').
:- include('save.pro').

/* If the license(yes) predicate is in the database then load the
 * getlicence.pl file.  If a call fails then it is printed at execution
 * time.  The second clause is included to prevent this.
*/

:- [initvals].  /* Dynamic predicates */


/* _After_ all dynamic predicates have been introduced, we need  */
/* to disable "dynamic" as an operator in case a user has an FDL */
/* entity called "dynamic".  Same goes for the other predefined  */
/* PROLOG operators that might look like FDL identifiers         */
/* See the SICSTUS manual section "Standard Operators"           */

:- op(0, fx, [mode,public,dynamic,multifile,volatile,block,meta_predicate,discontiguous,initialization]).
:- op(0, fx, [spy,nospy]).


/*** PREPARE CHECKER FOR SAVING !!! ***/

startup_sequence :-
    /* C1.41: newlines moved to after getlicence */
    machine_startup,                                            /* CFR048 */
    prompt(_OLD, ' '),
    process_command_line_data,
    display_header(user_output),
    format(user_output, '~n~n', []),
    read_initialisations,
    (load_vc),
    nl,
    write('Welcome to the SPADE Proof Checker -- for assistance type "help"'),
    nl,
    nl,
    fail.

%--------------------------------------------------------------------------------

startup_sequence :-
    load_buffered_libs,
    write_log,
    fail.
startup_sequence :-
    do_do_newvc,
    see_correct_input_stream,
    execute_command(newvc),
    write_log,
    fail.
startup_sequence :-
    !,
    start.

load_buffered_libs :-
        retract(ini_file_consult(FILE)),
        write('Consulting rule file '), print(FILE), write(' ...'), nl,
        user_rules(FILE),
        fail.
load_buffered_libs :- !.

machine_startup :-
        fetch_environment_variables,
        % 45 is '-'.
        assertz(qualifier_prefix(45)),
        % 47 is '/'.
        assertz(qualifier_prefix(47)),
        !.

%###############################################################################
%END-OF-FILE
