%  $Id: declar.pro 12104 2009-01-13 09:51:38Z Bill Ellis $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


declare_operators :-
        /* MOST-TIGHTLY-BINDING: */
        op(350, xfx, ** ),
        op(350, xf, ~),                             /* INITIAL VALUE POSTFIX */
        op(350, yfx, #),                            /* Attributes */


        /* NEXT */
        op(375,  fx, +  ),
        op(375,  fx, -  ),

        /* NEXT */
        op(400, yfx, *  ),
        op(400, yfx, /  ),
        op(400, yfx, div),
        op(400, yfx, mod),
        op(400, yfx, rem),
        op(400, yfx, @  ),
        op(400, yfx, /\ ),

        /* NEXT */
        op(500, yfx, +  ),
        op(500, yfx, -  ),
        op(500, yfx, \/ ),
        op(500, yfx, \  ),

        /* NEXT */
        op(700, fy,  set),                     /* Sets */
        op(700, yfx, <> ),
        op(700, yfx, subset_of ),
        op(700, yfx, strict_subset_of ),
        op(700, xfx, iss),                    /* Signed 'is' */
        op(700, yfx, less_than),              /* Arithmetic */
        op(700, yfx, <= ),

        /* Different ordering to Simplifier */
        op(800, yfx, in ),
        op(800, yfx, not_in ),
        op(800, yfx, '..'),                   /* Used for range notation */

        op(900,  fy, not ),

        op(925, yfx, and ),

        op(950, yfx, or  ),
        op(950, yfx, xor ),                   /* Guesstimated precedence! */

        /* Different ordering to Simplifier */
        op(975, yfx, ->  ),
        op(975, yfx, requires),

        op(985, yfx, <-> ),

/* Numbering different to Simplifier from here downwards */
        op(994, yfx, ':='),                   /* Used in array aggregates */

/* Consult and load don't appear in Simplifier */
        op(995,fx,consult),             /* For initialisation file */
        op(995,fx,load),                /* For initialisation file */
        op(995, yfx, &),                      /* Used in array aggregates */
        op(995, fx, rule_family),

/* Not in Simplifier */
        op(996,yfx,where),              /* New command-line syntax */

/* Not in Simplifier */
        op(997,yfx,by),         /* New command-line syntax */
        op(997,yfx,with),               /* New command-line syntax */
        op(997,yfx,to),         /* New command-line syntax */

        op(997, yfx, may_be_deduced_from),
        op(997, yfx, may_be_replaced_by),
        op(997, xf, are_interchangeable),
        op(997, yfx, if),
        op(997, xf, may_be_deduced),

/* Not in Simplifier */
        op(998,yfx,=>),           /* Substitution  */
        op(998,yfx,using),              /* New command-line syntax */
        op(998,yfx,for),                /* New command-line syntax */
        op(998,yfx,on),         /* New command-line syntax */

        op(999, xfy, :),                      /* Used in quantification */
/* Not in Simplifier */
        op(999,yfx,from),               /* New command-line syntax */

        !.

:- declare_operators.
%###############################################################################
%END-OF-FILE
