%  $Id: checker_ioutilities.pro 14238 2009-09-11 12:46:26Z dean kuo $
%-------------------------------------------------------------------------------
%  (C) Altran Praxis Limited
%-------------------------------------------------------------------------------
% 
%  The SPARK toolset is free software; you can redistribute it and/or modify it
%  under terms of the GNU General Public License as published by the Free
%  Software Foundation; either version 3, or (at your option) any later
%  version. The SPARK toolset is distributed in the hope that it will be
%  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
%  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
%  Public License for more details. You should have received a copy of the GNU
%  General Public License distributed with the SPARK toolset; see file
%  COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
%  the license.
% 
%===============================================================================


%###############################################################################
% PURPOSE
%-------------------------------------------------------------------------------
% Provides input and output utilities that are specific to the Checker.
%###############################################################################


%###############################################################################
% MODULE
%###############################################################################
:- module(simplifier_ioutilities, [display_header/1,
                                   display_help/1]).


%###############################################################################
% DEPENDENCIES
%###############################################################################

:- use_module('../simplifier/ioutilities.pro',
              [show_error/2,
               display_header_full/1,
               display_header_plain/1]).

:- use_module('../common/versioning/version.pro',
              [toolset_support_line1/1,
               toolset_support_line2/1,
               toolset_support_line3/1,
               toolset_support_line4/1]).


%###############################################################################
% TYPES
%###############################################################################


%###############################################################################
% DATA
%###############################################################################


%###############################################################################
% PREDICATES
%###############################################################################


%===============================================================================
% display_header(+Stream).
%-------------------------------------------------------------------------------
% Display the header for the Simplifier. For correct processing, the
% command line arguments must have already been processed.
%===============================================================================

% Is not in plain mode.
display_header(Stream):-
    user:plain_output(off),
    display_header_full(Stream),
    !.

% Is in plain mode.
display_header(Stream):-
    user:plain_output(on),
    display_header_plain(Stream),
    !.

%None of the above is an error.
display_header(_Stream):-
    show_error('Could not calcuate banner. Unexpected system configuration.', []).
%===============================================================================


%===============================================================================
% display_help(Stream).
%-------------------------------------------------------------------------------
% Display help text.
%===============================================================================

display_help(Stream):-

    display_header(Stream),

    % Get common support information.
    toolset_support_line1(SupportLine1_Atom),
    toolset_support_line2(SupportLine2_Atom),
    toolset_support_line3(SupportLine3_Atom),
    toolset_support_line4(SupportLine4_Atom),

    format(Stream, '~n',[]),
    format(Stream, 'Usage: checker [options] Target_File~n', []),
    format(Stream, '~n', []),
    format(Stream, 'Target_File - Either a .vcg or .siv file~n', []),
    format(Stream, '~n', []),
    format(Stream, 'All options may be abbreviated to the shortest unique prefix.~n', []),
    format(Stream, '~n', []),
    format(Stream, 'Standard options~n', []),
    format(Stream, '----------------~n', []),
    format(Stream, '-help                 - Display this help information.~n', []),
    format(Stream, '-version              - Display version information.~n', []),
    format(Stream, '-plain                - Adopt a plain output style (e.g. no dates~n', []),
    format(Stream, '                        or version numbers).~n', []),
    format(Stream, '-overwrite_warning    - Confirmation needed to overwrite command or~n', []),
    format(Stream, '                        proof log files.~n', []),
    format(Stream, '-command_log=Log_File - Specify filename for the command log file.~n', []),
    format(Stream, '-proof_log=Plg_File   - Specify filename for the proof log file.~n', []),
    format(Stream, '-execute=Log_File     - Execute a previously generated command log file.~n', []),
    format(Stream, '-resume               - Resume a previously saved session.~n', []),
    format(Stream, '~n', []),
    format(Stream, '~a~n', [SupportLine1_Atom]),
    format(Stream, '~a~n', [SupportLine2_Atom]),
    format(Stream, '~a~n', [SupportLine3_Atom]),
    format(Stream, '~a~n', [SupportLine4_Atom]),
    !.
%===============================================================================


%###############################################################################
% END-OF-FILE
