-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

---------------------------------------------------------------------------
--
-- - CFR  825 - PNA - Modify to produce GNAT style-compliant source code
-- - CFR 1023 - RCC - Modify to produce Unreferenced pragmas where needed
-- - CFR 1350 - RCC - Hide SPRelations body for SPARKMake Tool
-- - CFR 1480 - JMA - Modifications to compile under GNU Pascal 3.2.3
-- -                  ("COMP" now a reserved word; no $ allowed in identifiers;
-- -                  functions implemented in C declared as "external", not "C")
-- - CFR 1613 - RCC - Modifications for GPC 3.4.5 and first port to Mac OS X
-- - CFR 1929 - GA  - Creating of a SPARK implementation of SPARKLALR, based on
--                    existing Pascal implementation.
---------------------------------------------------------------------------

with Sparklalr_IO;
with Sparklalr_Symbol;
with Sparklalr_Common;
with Command_Line_Options;
with Sparklalr_Error;
with Symbols_Dump;
with Sparklalr_Goto;
with Sparklalr_Parser;
with Sparklalr_Patab;
with Sparklalr_Input;
with Sparklalr_Memory;
with Sparklalr_Memory.Dump;
with Sparklalr_Memory.Left_Corner;
with Sparklalr_Conflict;
with Ees_Sym;

use type Sparklalr_Symbol.Symbol;

--# inherit Command_Line_Options,
--#         Ees_Sym,
--#         Sparklalr_Char_Class,
--#         Sparklalr_Common,
--#         Sparklalr_Conflict,
--#         Sparklalr_Error,
--#         Sparklalr_Goto,
--#         Sparklalr_Input,
--#         Sparklalr_IO,
--#         Sparklalr_Level,
--#         Sparklalr_Memory,
--#         Sparklalr_Memory.Dump,
--#         Sparklalr_Memory.Left_Corner,
--#         Sparklalr_Parser,
--#         Sparklalr_Patab,
--#         Sparklalr_Symbol,
--#         Symbols_Dump;

--# main_program;
procedure Sparklalr
--# global in out Sparklalr_IO.Inputs;
--#        in out Sparklalr_IO.Outputs;
--#        in out Sparklalr_IO.State;
--#           out Command_Line_Options.State;
--#           out Ees_Sym.State;
--#           out Sparklalr_Char_Class.Charmap;
--#           out Sparklalr_Conflict.State;
--#           out Sparklalr_Error.State;
--#           out Sparklalr_Goto.State;
--#           out Sparklalr_Input.State;
--#           out Sparklalr_Level.State;
--#           out Sparklalr_Memory.Dump.State;
--#           out Sparklalr_Memory.Left_Corner.State;
--#           out Sparklalr_Memory.Max_Right;
--#           out Sparklalr_Memory.Prod_No;
--#           out Sparklalr_Memory.Prod_Sum;
--#           out Sparklalr_Memory.Stat_No;
--#           out Sparklalr_Parser.State;
--#           out Sparklalr_Patab.State;
--#           out Symbols_Dump.State;
--# derives Command_Line_Options.State         from Sparklalr_IO.State &
--#         Ees_Sym.State,
--#         Sparklalr_Conflict.State,
--#         Sparklalr_Error.State,
--#         Sparklalr_Goto.State,
--#         Sparklalr_Input.State,
--#         Sparklalr_IO.Inputs,
--#         Sparklalr_IO.State,
--#         Sparklalr_Level.State,
--#         Sparklalr_Memory.Dump.State,
--#         Sparklalr_Memory.Left_Corner.State,
--#         Sparklalr_Memory.Max_Right,
--#         Sparklalr_Memory.Prod_No,
--#         Sparklalr_Memory.Prod_Sum,
--#         Sparklalr_Memory.Stat_No,
--#         Sparklalr_Parser.State,
--#         Sparklalr_Patab.State,
--#         Symbols_Dump.State                 from Sparklalr_IO.Inputs,
--#                                                 Sparklalr_IO.State &
--#         Sparklalr_Char_Class.Charmap       from  &
--#         Sparklalr_IO.Outputs               from *,
--#                                                 Sparklalr_IO.Inputs,
--#                                                 Sparklalr_IO.State;
is

   subtype Ampterm_Ampgram_Range is Sparklalr_Symbol.Symbol range Sparklalr_Symbol.Ampterm .. Sparklalr_Symbol.Ampgram;
   subtype Ampprog_Ampmain is Sparklalr_Symbol.Symbol range Sparklalr_Symbol.Ampprog .. Sparklalr_Symbol.Ampmain;

   Echo         : Sparklalr_IO.File_Type;
   Spark_Output : Sparklalr_IO.File_Type;

   Col        : Sparklalr_Error.Err_Col_T;
   Symb       : Sparklalr_Symbol.Symbol;
   Gram_Rules : Boolean;

   Signpost : Sparklalr_Input.Symbol_Set_Type;

   User_Code : Boolean;
   File_Name : Sparklalr_IO.File_Name;
   Symb_Set  : Sparklalr_Input.Symbol_Set_Type;

   I : Sparklalr_Symbol.Symbol;

   procedure Initialise (File_Name : in Sparklalr_IO.File_Name)
   --# global in     Command_Line_Options.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_IO.State;
   --#           out Col;
   --#           out Echo;
   --#           out Gram_Rules;
   --#           out Signpost;
   --#           out Sparklalr_Char_Class.Charmap;
   --#           out Sparklalr_Conflict.State;
   --#           out Sparklalr_Error.State;
   --#           out Sparklalr_Goto.State;
   --#           out Sparklalr_Input.State;
   --#           out Sparklalr_Level.State;
   --#           out Sparklalr_Memory.Dump.State;
   --#           out Sparklalr_Memory.Max_Right;
   --#           out Sparklalr_Memory.Prod_No;
   --#           out Sparklalr_Memory.Prod_Sum;
   --#           out Sparklalr_Memory.Stat_No;
   --#           out Sparklalr_Parser.State;
   --#           out Sparklalr_Patab.State;
   --#           out Spark_Output;
   --#           out Symb;
   --#           out Symbols_Dump.State;
   --# derives Col,
   --#         Gram_Rules,
   --#         Signpost,
   --#         Sparklalr_Char_Class.Charmap,
   --#         Sparklalr_Conflict.State,
   --#         Sparklalr_Goto.State,
   --#         Sparklalr_Level.State,
   --#         Sparklalr_Memory.Max_Right,
   --#         Sparklalr_Memory.Prod_No,
   --#         Sparklalr_Memory.Prod_Sum,
   --#         Sparklalr_Memory.Stat_No,
   --#         Sparklalr_Parser.State,
   --#         Sparklalr_Patab.State,
   --#         Symb,
   --#         Symbols_Dump.State           from  &
   --#         Echo,
   --#         Sparklalr_Input.State,
   --#         Sparklalr_IO.State,
   --#         Spark_Output                 from Command_Line_Options.State,
   --#                                           File_Name,
   --#                                           Sparklalr_IO.State &
   --#         Sparklalr_Error.State,
   --#         Sparklalr_IO.Inputs          from Command_Line_Options.State,
   --#                                           File_Name,
   --#                                           Sparklalr_IO.Inputs,
   --#                                           Sparklalr_IO.State &
   --#         Sparklalr_IO.Outputs         from *,
   --#                                           Command_Line_Options.State &
   --#         Sparklalr_Memory.Dump.State  from Command_Line_Options.State,
   --#                                           Sparklalr_IO.State;
   is
      File_Success : Boolean;
   begin
      Symbols_Dump.Initialise;
      Sparklalr_Memory.Dump.Initialise;
      Sparklalr_Goto.Initialise;
      Col := 0;
      Sparklalr_IO.Rewrite (Echo, File_Name, ".EKO", File_Success);
      if not File_Success then
         Sparklalr_IO.Exit_St ("Unable to open output EKO file", Sparklalr_IO.Error);
      end if;
      if Command_Line_Options.Get_Parser then
         Sparklalr_IO.Rewrite (Spark_Output, File_Name, ".PAR", File_Success);
         if not File_Success then
            Sparklalr_IO.Exit_St ("Unable to open output PAR file", Sparklalr_IO.Error);
         end if;
      end if;
      Sparklalr_Parser.Initialise;
      Sparklalr_Patab.Initialise;
      Sparklalr_Conflict.Initialise;
      Gram_Rules := True;
      Sparklalr_Input.Initialise (Signpost);
      Symb := Sparklalr_Symbol.Nullsymb;
      --# accept F, 602, Spark_Output, Spark_Output, "Always defined before used";
   end Initialise;

   procedure Grammar (File_Name : in Sparklalr_IO.File_Name)
   --# global in     Command_Line_Options.State;
   --#        in     Echo;
   --#        in     Gram_Rules;
   --#        in     Signpost;
   --#        in     Sparklalr_Char_Class.Charmap;
   --#        in out Col;
   --#        in out Sparklalr_Conflict.State;
   --#        in out Sparklalr_Error.State;
   --#        in out Sparklalr_Goto.State;
   --#        in out Sparklalr_Input.State;
   --#        in out Sparklalr_IO.Inputs;
   --#        in out Sparklalr_IO.Outputs;
   --#        in out Sparklalr_IO.State;
   --#        in out Sparklalr_Level.State;
   --#        in out Sparklalr_Memory.Dump.State;
   --#        in out Sparklalr_Memory.Max_Right;
   --#        in out Sparklalr_Memory.Prod_No;
   --#        in out Sparklalr_Memory.Prod_Sum;
   --#        in out Sparklalr_Memory.Stat_No;
   --#        in out Sparklalr_Parser.State;
   --#        in out Sparklalr_Patab.State;
   --#        in out Symbols_Dump.State;
   --#           out Symb;
   --# derives Col,
   --#         Sparklalr_Input.State,
   --#         Sparklalr_IO.Inputs,
   --#         Sparklalr_Memory.Prod_No,
   --#         Symb,
   --#         Symbols_Dump.State          from Col,
   --#                                          Command_Line_Options.State,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_Conflict.State,
   --#         Sparklalr_Memory.Dump.State,
   --#         Sparklalr_Memory.Prod_Sum,
   --#         Sparklalr_Parser.State,
   --#         Sparklalr_Patab.State       from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          Gram_Rules,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Goto.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Level.State,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Sparklalr_Parser.State,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_Error.State,
   --#         Sparklalr_Goto.State,
   --#         Sparklalr_Memory.Stat_No    from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Goto.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Sparklalr_Parser.State,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_IO.Outputs        from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          Echo,
   --#                                          File_Name,
   --#                                          Gram_Rules,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Conflict.State,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Goto.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_IO.State,
   --#                                          Sparklalr_Level.State,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Sparklalr_Parser.State,
   --#                                          Sparklalr_Patab.State,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_IO.State          from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          File_Name,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_Level.State       from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          Gram_Rules,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Symbols_Dump.State &
   --#         Sparklalr_Memory.Max_Right  from *,
   --#                                          Col,
   --#                                          Command_Line_Options.State,
   --#                                          Gram_Rules,
   --#                                          Signpost,
   --#                                          Sparklalr_Char_Class.Charmap,
   --#                                          Sparklalr_Error.State,
   --#                                          Sparklalr_Goto.State,
   --#                                          Sparklalr_Input.State,
   --#                                          Sparklalr_IO.Inputs,
   --#                                          Sparklalr_Level.State,
   --#                                          Sparklalr_Memory.Dump.State,
   --#                                          Sparklalr_Memory.Prod_No,
   --#                                          Sparklalr_Memory.Prod_Sum,
   --#                                          Sparklalr_Parser.State,
   --#                                          Symbols_Dump.State;
   is

      Symbolset_Skipto : Sparklalr_Input.Symbol_Set_Type;
      Grammar_Token    : Sparklalr_Common.Id_Name;

      procedure Out_Pt (File_Name : in Sparklalr_IO.File_Name)
      --# global in     Command_Line_Options.State;
      --#        in     Echo;
      --#        in     Sparklalr_Conflict.State;
      --#        in     Sparklalr_Goto.State;
      --#        in     Sparklalr_Memory.Dump.State;
      --#        in     Sparklalr_Memory.Prod_No;
      --#        in     Sparklalr_Memory.Stat_No;
      --#        in     Sparklalr_Parser.State;
      --#        in     Sparklalr_Patab.State;
      --#        in     Symbols_Dump.State;
      --#        in out Sparklalr_IO.Outputs;
      --#        in out Sparklalr_IO.State;
      --#        in out Sparklalr_Memory.Prod_Sum;
      --#           out Sparklalr_Memory.Max_Right;
      --# derives Sparklalr_IO.Outputs       from *,
      --#                                         Command_Line_Options.State,
      --#                                         Echo,
      --#                                         File_Name,
      --#                                         Sparklalr_Conflict.State,
      --#                                         Sparklalr_Goto.State,
      --#                                         Sparklalr_IO.State,
      --#                                         Sparklalr_Memory.Dump.State,
      --#                                         Sparklalr_Memory.Prod_No,
      --#                                         Sparklalr_Memory.Stat_No,
      --#                                         Sparklalr_Parser.State,
      --#                                         Sparklalr_Patab.State,
      --#                                         Symbols_Dump.State &
      --#         Sparklalr_IO.State         from *,
      --#                                         Command_Line_Options.State,
      --#                                         File_Name &
      --#         Sparklalr_Memory.Max_Right,
      --#         Sparklalr_Memory.Prod_Sum  from Sparklalr_Memory.Dump.State,
      --#                                         Sparklalr_Memory.Prod_No,
      --#                                         Sparklalr_Memory.Prod_Sum;
      is

         -- - This procedure highlights any redundant productions in an input grammar -
         procedure Check_Consistency (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Symbols_Dump.State;
         --#        in out Sparklalr_IO.Outputs;
         --# derives Sparklalr_IO.Outputs from *,
         --#                                   F,
         --#                                   Sparklalr_Goto.State,
         --#                                   Sparklalr_Memory.Stat_No,
         --#                                   Symbols_Dump.State;
         is
            J       : Integer;
            Nt_Used : Boolean;
            Posn    : Integer;
         begin
            for I in Integer range 2 .. Symbols_Dump.Get_Nnon_Terms loop
               Nt_Used := False;
               J       := 1;
               while (not Nt_Used) and (J <= Sparklalr_Memory.Get_Stat_No) loop
                  Nt_Used := Sparklalr_Goto.Goto_Search (J, I + Sparklalr_Common.Nt_Base) /= 0;
                  J       := J + 1;
               end loop;
               if not Nt_Used then
                  Sparklalr_IO.Put (F, "**** WARNING NON-TERMINAL ");
                  Posn := 27;
                  --# accept F, 10, Posn, "Ineffective assignment here expected and OK";
                  Sparklalr_Common.Print (F, Symbols_Dump.Get_Nterm_Set (I), Posn, 27, False);
                  --# end accept;
                  Sparklalr_IO.Put_Line (F, " IS DEFINED BUT NEVER USED.");
                  Sparklalr_IO.Put_Line (F, "     This may produce an inconsistent parser!!!");
               end if;
            end loop;
         end Check_Consistency;

         procedure Statistics (F : in Sparklalr_IO.File_Type)
         --# global in     Sparklalr_Conflict.State;
         --#        in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Dump.State;
         --#        in     Sparklalr_Memory.Prod_No;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Sparklalr_Parser.State;
         --#        in     Sparklalr_Patab.State;
         --#        in     Symbols_Dump.State;
         --#        in out Sparklalr_IO.Outputs;
         --# derives Sparklalr_IO.Outputs from *,
         --#                                   F,
         --#                                   Sparklalr_Conflict.State,
         --#                                   Sparklalr_Goto.State,
         --#                                   Sparklalr_Memory.Dump.State,
         --#                                   Sparklalr_Memory.Prod_No,
         --#                                   Sparklalr_Memory.Stat_No,
         --#                                   Sparklalr_Parser.State,
         --#                                   Sparklalr_Patab.State,
         --#                                   Symbols_Dump.State;
         is
         begin
            Sparklalr_IO.New_Line (F);
            Sparklalr_Conflict.Conflict_Stats (F);
            Sparklalr_IO.Put_Int (F, Symbols_Dump.Get_Nterms, 6);
            Sparklalr_IO.Put (F, " TERMINALS (");
            Sparklalr_IO.Put_Int (F, Sparklalr_Common.Term_Lim, 1);
            Sparklalr_IO.Put_Line (F, " MAX)");
            Sparklalr_IO.Put_Int (F, Symbols_Dump.Get_Nnon_Terms, 6);
            Sparklalr_IO.Put (F, " NONTERMINALS (");
            Sparklalr_IO.Put_Int (F, Sparklalr_Common.Non_Term_Lim, 1);
            Sparklalr_IO.Put_Line (F, " MAX)");
            Sparklalr_IO.Put_Int (F, Sparklalr_Memory.Get_Prod_No - 1, 6);
            Sparklalr_IO.Put (F, " PRODUCTIONS (");
            Sparklalr_IO.Put_Int (F, Sparklalr_Common.Prod_Lim, 1);
            Sparklalr_IO.Put_Line (F, " MAX)");
            Sparklalr_IO.Put_Int (F, Sparklalr_Memory.Get_Stat_No, 6);
            Sparklalr_IO.Put (F, " STATES (");
            Sparklalr_IO.Put_Int (F, Sparklalr_Common.State_Max, 1);
            Sparklalr_IO.Put_Line (F, " MAX)");
            Sparklalr_Parser.Pa_Stats (F);
            Sparklalr_Goto.Goto_Stats (F);
            Sparklalr_Patab.Opt_Stats (F);
            Sparklalr_Memory.Dump.Mem_Stats (F);
         end Statistics;

         procedure Dump_Verb (File_Name : in Sparklalr_IO.File_Name)
         --# global in     Echo;
         --#        in     Sparklalr_Conflict.State;
         --#        in     Sparklalr_Goto.State;
         --#        in     Sparklalr_Memory.Dump.State;
         --#        in     Sparklalr_Memory.Prod_No;
         --#        in     Sparklalr_Memory.Stat_No;
         --#        in     Sparklalr_Parser.State;
         --#        in     Sparklalr_Patab.State;
         --#        in     Symbols_Dump.State;
         --#        in out Sparklalr_IO.Outputs;
         --#        in out Sparklalr_IO.State;
         --# derives Sparklalr_IO.Outputs from *,
         --#                                   Echo,
         --#                                   File_Name,
         --#                                   Sparklalr_Conflict.State,
         --#                                   Sparklalr_Goto.State,
         --#                                   Sparklalr_IO.State,
         --#                                   Sparklalr_Memory.Dump.State,
         --#                                   Sparklalr_Memory.Prod_No,
         --#                                   Sparklalr_Memory.Stat_No,
         --#                                   Sparklalr_Parser.State,
         --#                                   Sparklalr_Patab.State,
         --#                                   Symbols_Dump.State &
         --#         Sparklalr_IO.State   from *,
         --#                                   File_Name;
         is

            Descript     : Sparklalr_IO.File_Type;
            File_Success : Boolean;

            procedure Dump_States (F : in Sparklalr_IO.File_Type)
            --# global in     Sparklalr_Conflict.State;
            --#        in     Sparklalr_Memory.Dump.State;
            --#        in     Sparklalr_Memory.Stat_No;
            --#        in     Sparklalr_Parser.State;
            --#        in     Symbols_Dump.State;
            --#        in out Sparklalr_IO.Outputs;
            --# derives Sparklalr_IO.Outputs from *,
            --#                                   F,
            --#                                   Sparklalr_Conflict.State,
            --#                                   Sparklalr_Memory.Dump.State,
            --#                                   Sparklalr_Memory.Stat_No,
            --#                                   Sparklalr_Parser.State,
            --#                                   Symbols_Dump.State;
            is
               S, T : Sparklalr_Memory.Dump.Pt_Memory;
            begin
               for I in Integer range 1 .. Sparklalr_Memory.Get_Stat_No loop
                  Sparklalr_IO.New_Line (F);
                  Sparklalr_IO.Put (F, " STATE ");
                  Sparklalr_IO.Put_Int (F, I, 4);
                  Sparklalr_IO.New_Line (F);
                  S := Sparklalr_Memory.Dump.Get_State (I);
                  T := Sparklalr_Memory.Dump.Get_State (I + 1);
                  Sparklalr_Memory.Dump.Dump_Items (F, S, T);
                  Sparklalr_IO.New_Line (F);
                  Sparklalr_Parser.Dump_Actions (F, I);
                  Sparklalr_IO.New_Line (F);
                  Sparklalr_Conflict.Dump_Conflicts (F, I);
               end loop;
            end Dump_States;

         begin
            Sparklalr_IO.Rewrite (Descript, File_Name, ".DSC", File_Success);
            if not File_Success then
               Sparklalr_IO.Exit_St ("Unable to open output DSC file", Sparklalr_IO.Error);
            end if;
            Sparklalr_Memory.Dump.Dump_Prdns (Descript);
            Check_Consistency (Descript);
            Dump_States (Descript);
            Sparklalr_Goto.Dump_Goto (Descript);
            Statistics (Echo);
            Statistics (Descript);
            Statistics (Sparklalr_IO.Standard_Output);
         end Dump_Verb;

      begin
         if Command_Line_Options.Get_Verbose then
            Dump_Verb (File_Name);
         else
            Sparklalr_Memory.Dump.Dump_Prdns (Echo);
            Check_Consistency (Sparklalr_IO.Standard_Output);
            Statistics (Sparklalr_IO.Standard_Output);
            Check_Consistency (Echo);
            Sparklalr_Conflict.Print_Conflicts (Echo);
            Statistics (Echo);
         end if;
         if Command_Line_Options.Get_Dump_Mem then
            Sparklalr_Memory.Dump.Mem_Dump;
         end if;
         Sparklalr_Memory.Dump.Summary;
      end Out_Pt;

   begin
      Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
      while not Sparklalr_Input.Get_Symbol_Set (Signpost, Symb) loop
         if Symb = Sparklalr_Symbol.Ident then
            Sparklalr_Memory.Dump.Lhs_Process (Echo, Gram_Rules, Grammar_Token, Col);
            --# accept F, 10, Grammar_Token, "Ineffective assignment here expected and OK";
            Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
            --# end accept;
            if Symb = Sparklalr_Symbol.Colon then
               loop
                  Sparklalr_Memory.Dump.Rhs_Process (Echo, Symb, Gram_Rules, Col, Signpost);
                  exit when Symb /= Sparklalr_Symbol.Uparrow;
               end loop;
            else
               Sparklalr_Error.Syn_Error (6, Col);
            end if;
         else
            Sparklalr_Error.Syn_Error (7, Col);
            Symbolset_Skipto := Sparklalr_Input.Signpost_To_Symbol_Set_Type (Signpost);
            Sparklalr_Input.Set_Symbol_Set (Symbolset_Skipto, Sparklalr_Symbol.Scolon, True);
            --# accept F, 10, Symb, "Ineffective assignment here expected and OK";
            Sparklalr_Input.Skipto (Echo, Symbolset_Skipto, Col, Symb);
            --# end accept;
         end if;
         Sparklalr_Input.Scan (Echo, Col, Symb, Grammar_Token);
      end loop;
      if not Sparklalr_Error.Get_Prod_Err then
         Sparklalr_Memory.Dump.Findntredns (Echo);
      end if;
      if not Sparklalr_Error.Get_Prod_Err then
         Sparklalr_Memory.Dump.State_Generation (Echo);
         Sparklalr_Conflict.Parse_Action_Generation (Echo);
         Out_Pt (File_Name);
      end if;
   end Grammar;

begin
   Command_Line_Options.Get_Options;
   File_Name := Command_Line_Options.Get_File_Name;
   Initialise (File_Name);
   for K in Ampterm_Ampgram_Range loop
      if Symb < K then
         Symb_Set := Sparklalr_Input.Symbol_Set_False_Const;
         I        := K;
         while I < Sparklalr_Symbol.Endfile loop
            Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
            I := Sparklalr_Symbol.Symbol'Succ (I);
         end loop;
         Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
         Sparklalr_Input.Skipto (Echo, Symb_Set, Col, Symb);
      end if;
      User_Code := K = Symb;
      case K is
         when Sparklalr_Symbol.Ampterm =>
            if User_Code then
               Sparklalr_Input.Proc_Term (Echo, Gram_Rules, Col, Signpost, Symb);
            end if;
         when Sparklalr_Symbol.Ampgram =>
            if User_Code then
               Grammar (File_Name);
            else
               Sparklalr_Error.Error (Echo, 1);
            end if;
      end case;
      Sparklalr_Error.List_Line_Errors (Echo, Col);
   end loop;
   if Command_Line_Options.Get_Parser and (not Sparklalr_Error.Get_Prod_Err) then
      for K in Ampprog_Ampmain loop
         if Symb < K then
            Symb_Set := Sparklalr_Input.Symbol_Set_False_Const;
            I        := K;
            while I < Sparklalr_Symbol.Endfile loop
               Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
               I := Sparklalr_Symbol.Symbol'Succ (I);
            end loop;
            Sparklalr_Input.Set_Symbol_Set (Symb_Set, I, True);
            Sparklalr_Input.Skipto (Echo, Symb_Set, Col, Symb);
         end if;
         case K is
            when Sparklalr_Symbol.Ampprog =>
               -- The following relations must be generated before output generation
               Sparklalr_IO.New_Line (Sparklalr_IO.Standard_Output);
               Sparklalr_IO.Put_Line
                 (Sparklalr_IO.Standard_Output,
                  "Determing Shift States, Reduce States, and Unique Reduce States...");
               Sparklalr_Parser.Gen_State_Info;
               Sparklalr_IO.Put_Line (Sparklalr_IO.Standard_Output, "Generating relation Left Corner...");
               Sparklalr_Memory.Left_Corner.Gen_Left_Corner;
               Sparklalr_IO.Put_Line (Sparklalr_IO.Standard_Output, "Generating Essential Expected Symbols...");
               Ees_Sym.Gen_Essentials;
               Sparklalr_IO.Put_Line (Sparklalr_IO.Standard_Output, "Calculating Table Sizes...");
               Sparklalr_Patab.Calc_Table_Sizes;
               Sparklalr_Memory.Left_Corner.Count_Left_Corners;
               Ees_Sym.Out_Essentials;
               -- --------------------------------------------------------------------
               -- -------- Main section of SPARK parser table generartion ------------
               Sparklalr_IO.Put_Line (Sparklalr_IO.Standard_Output, "Generating SPARK Parser Tables...");
               Sparklalr_Memory.Dump.Productions_Package_Out (Spark_Output);
               Sparklalr_IO.New_Line (Spark_Output);
               Symbols_Dump.Symbols_Package_Out (Spark_Output);
               Sparklalr_IO.New_Line (Spark_Output);
               Symbols_Dump.Symbol_Strings_Out;
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "with SPProductions, SPSymbols;");
               Sparklalr_IO.Put_Line (Spark_Output, "--# inherit SPProductions,");
               Sparklalr_IO.Put_Line (Spark_Output, "--#         SPSymbols;");
               Sparklalr_IO.Put_Line (Spark_Output, "package SPParserActions");
               Sparklalr_IO.Put_Line (Spark_Output, "is");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   type SPActionKind is (Error, Shift, Reduce, Accpt);");
               Sparklalr_IO.Put_Line (Spark_Output, "   type SPParseAct is record");
               Sparklalr_IO.Put_Line (Spark_Output, "      Act    : SPActionKind;");
               Sparklalr_IO.Put_Line (Spark_Output, "      State  : SPProductions.SPState;");
               Sparklalr_IO.Put_Line (Spark_Output, "      Symbol : SPSymbols.SPSymbol;");
               Sparklalr_IO.Put_Line (Spark_Output, "      RedBy  : SPProductions.SPRight;");
               Sparklalr_IO.Put_Line (Spark_Output, "      ProdNo : SPProductions.SPProdNo;");
               Sparklalr_IO.Put_Line (Spark_Output, "   end record;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   type ActionIndex is private;");
               Sparklalr_IO.Put_Line (Spark_Output, "   FirstActionIndex : constant ActionIndex;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   NoSym     : constant SPSymbols.SPSymbol := SPSymbols.SPDEFAULT;");
               Sparklalr_IO.Put_Line (Spark_Output, "   NoRed     : constant SPProductions.SPRight  := 0;");
               Sparklalr_IO.Put_Line (Spark_Output, "   NoProd    : constant SPProductions.SPProdNo := 0;");
               Sparklalr_IO.Put_Line (Spark_Output, "   AcceptAction : constant SPParseAct := SPParseAct'(Accpt,");
               Sparklalr_IO.Put_Line (Spark_Output, "                    SPProductions.NoState, NoSym, NoRed, NoProd);");
               Sparklalr_IO.Put_Line (Spark_Output, "   ErrorAction  : constant SPParseAct := SPParseAct'(Error,");
               Sparklalr_IO.Put_Line (Spark_Output, "                    SPProductions.NoState, NoSym, NoRed, NoProd);");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   function SPA (CST : SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line (Spark_Output, "                 CSY : SPSymbols.SPTerminal) return SPParseAct;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   procedure ScanActionTable (StateNo  : in SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              Index    : in out ActionIndex;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              ParseAct : out SPParseAct;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              ActionSymbol : out SPSymbols.SPTerminal);");
               Sparklalr_IO.Put_Line (Spark_Output, "   --# derives ActionSymbol,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#         Index,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#         ParseAct     from Index,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#                           StateNo;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "private");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put (Spark_Output, "   MaxPATSegment : constant Natural := ");
               Sparklalr_IO.Put_Int (Spark_Output, Sparklalr_Patab.Get_Pat_Seg_Count, 1);
               Sparklalr_IO.Put_Line (Spark_Output, ";");
               Sparklalr_IO.Put_Line (Spark_Output, "   type ActionIndex is range 0 .. MaxPATSegment;");
               Sparklalr_IO.Put_Line (Spark_Output, "   FirstActionIndex : constant ActionIndex := 0;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "end SPParserActions;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "with SPProductions, SPSymbols;");
               Sparklalr_IO.Put_Line (Spark_Output, "use type SPProductions.SPState;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "--# inherit SPProductions,");
               Sparklalr_IO.Put_Line (Spark_Output, "--#         SPSymbols;");
               Sparklalr_IO.Put_Line (Spark_Output, "package SPParserGoto");
               Sparklalr_IO.Put_Line (Spark_Output, "is");
               Sparklalr_IO.Put_Line (Spark_Output, "   type GotoIndex is private;");
               Sparklalr_IO.Put_Line (Spark_Output, "   FirstGotoIndex : constant GotoIndex;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   function SPGoto (CST : SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line
                 (Spark_Output,
                  "                    CSY : SPSymbols.SPNonTerminal) return SPProductions.SPState;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   procedure ScanGotoTable (StateNo : in SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            Index   : in out GotoIndex;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            GoalState : out SPProductions.SPState;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            ReductionGoal : out SPSymbols.SPNonTerminal);");
               Sparklalr_IO.Put_Line (Spark_Output, "   --# derives GoalState,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#         Index,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#         ReductionGoal from Index,");
               Sparklalr_IO.Put_Line (Spark_Output, "   --#                            StateNo;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "private");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put (Spark_Output, "   NoOfGotoEntries : constant Positive := ");
               Sparklalr_IO.Put_Int (Spark_Output, Sparklalr_Goto.Get_Goto_List_Count, 1);
               Sparklalr_IO.Put_Line (Spark_Output, ";");
               Sparklalr_IO.Put_Line (Spark_Output, "   type GotoIndex is range 1 .. NoOfGotoEntries + 1;");
               Sparklalr_IO.Put_Line (Spark_Output, "   FirstGotoIndex : constant GotoIndex := 1;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "end SPParserGoto;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "package body SPParserActions is");
               --# accept F, 41, "Stable expression here expected and OK";
               if Command_Line_Options.Get_Self_Pack then
                  Sparklalr_Patab.Pa_Out_Sp (Spark_Output);
               else
                  Sparklalr_Patab.Pa_Out (Spark_Output);
               end if;
               --# end accept;
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put (Spark_Output, "   function SPA (CST : SPProductions.ValidStates; ");
               Sparklalr_IO.Put_Line (Spark_Output, "                 CSY : SPSymbols.SPTerminal) return SPParseAct");
               Sparklalr_IO.Put_Line (Spark_Output, "   is separate;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   procedure ScanActionTable (StateNo  : in SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              Index    : in out ActionIndex;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              ParseAct : out SPParseAct;");
               Sparklalr_IO.Put_Line (Spark_Output, "                              ActionSymbol : out SPSymbols.SPTerminal)");
               Sparklalr_IO.Put_Line (Spark_Output, "   is separate;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "end SPParserActions;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "package body SPParserGoto is");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   subtype GOTIndex is GotoIndex range 1 .. GotoIndex'Last - 1;");
               --# accept F, 41, "Stable expression here expected and OK";
               if Command_Line_Options.Get_Self_Pack then
                  Sparklalr_Goto.Goto_Out_Sp (Spark_Output);
               else
                  Sparklalr_Goto.Goto_Out (Spark_Output);
               end if;
               --# end accept;
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   function SPGoto (CST : SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line
                 (Spark_Output,
                  "                    CSY : SPSymbols.SPNonTerminal) return SPProductions.SPState");
               Sparklalr_IO.Put_Line (Spark_Output, "   is separate;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "   procedure ScanGotoTable (StateNo : in SPProductions.ValidStates;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            Index   : in out GotoIndex;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            GoalState : out SPProductions.SPState;");
               Sparklalr_IO.Put_Line (Spark_Output, "                            ReductionGoal : out SPSymbols.SPNonTerminal)");
               Sparklalr_IO.Put_Line (Spark_Output, "   is separate;");
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_IO.Put_Line (Spark_Output, "end SPParserGoto;");
               Sparklalr_IO.New_Line (Spark_Output);
               Ees_Sym.Sp_Exp_Out (Spark_Output);
               Sparklalr_IO.New_Line (Spark_Output);
               Sparklalr_Memory.Left_Corner.Out_Left_Corner (Spark_Output);
               -- ---------------------------------------------------------------------------
               -- ---- Program fragments must not be included in a SPARKLALR grammar file ---
            when Sparklalr_Symbol.Amplabel =>
               null;
            when Sparklalr_Symbol.Ampconst =>
               null;
            when Sparklalr_Symbol.Amptype =>
               null;
            when Sparklalr_Symbol.Ampvar =>
               null;
            when Sparklalr_Symbol.Ampfunc =>
               null;
            when Sparklalr_Symbol.Ampmain =>
               null;
         end case;
         -- ----------------------------------------------------------------------------
         Sparklalr_Error.List_Line_Errors (Echo, Col);
      end loop;
   end if;
   Sparklalr_Input.Finalize (Echo);

   --# accept F, 602, Ees_Sym.State, Ees_Sym.State, "Always defined before used" &
   --#        F, 602, Sparklalr_Memory.Left_Corner.State, Sparklalr_Memory.Left_Corner.State, "Always defined before used";
end Sparklalr;
