-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit.WalkStatements)
procedure up_case (Node : in STree.SyntaxNode) is
   Unused1     : Dictionary.Symbol;
   CaseFlags   : Typ_Case_Flags;
   Unused2     : Typ_Type_Bound;
   Unused3     : Typ_Type_Bound;
   CompleteADT : CompleteCheck.T;
   OthersFound : Boolean;
begin
   -- ASSUME Node = case_statement
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Node) = SPSymbols.case_statement,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Node = case_statement in Up_Case");

   --# accept Flow, 10, Unused1, "Expected ineffective assignment" &
   --#        Flow, 10, Unused2, "Expected ineffective assignment" &
   --#        Flow, 10, Unused3, "Expected ineffective assignment";
   Case_Stack.Pop (CaseFlags, CompleteADT, Unused1, Unused2, Unused3);
   --# end accept;

   -- if there is an others clause record the fact and inform ADT
   if Child_Node (Next_Sibling (Next_Sibling (Child_Node (Node)))) /= STree.NullNode then
      OthersFound := True;
      -- check to see if case was already complete before others found
      if CaseFlags.Check_Completeness and then CompleteCheck.IsComplete (CompleteADT) = CompleteCheck.Complete then
         ErrorHandler.Semantic_Warning
           (Err_Num  => 11,
            Position => Node_Position (Node => Child_Node (Next_Sibling (Next_Sibling (Child_Node (Node))))),
            Id_Str   => LexTokenManager.Null_String);
      end if;
      -- now signal "others found"  to completeness checker
      CompleteCheck.SeenOthers (CompleteADT);
   else
      OthersFound := False;
   end if;

   if CaseFlags.Check_Completeness then
      if CompleteADT.Undeterminable and not OthersFound then
         ErrorHandler.Semantic_Warning
           (Err_Num  => 304,
            Position => Node_Position (Node => Node),
            Id_Str   => LexTokenManager.Null_String);

      elsif CompleteCheck.IsComplete (CompleteADT) = CompleteCheck.Incomplete then
         ErrorHandler.Semantic_Error
           (Err_Num   => 408,
            Reference => ErrorHandler.No_Reference,
            Position  => Node_Position (Node => Node),
            Id_Str    => LexTokenManager.Null_String);
      end if;
   end if;

   if CaseFlags.Signal_Out_Of_Range and CaseFlags.Out_Of_Range_Seen then
      ErrorHandler.Semantic_Warning
        (Err_Num  => 303,
         Position => Node_Position (Node => Node),
         Id_Str   => LexTokenManager.Null_String);
   end if;

   if CaseFlags.Warn_No_Others and
     not OthersFound and
     not (CaseFlags.Check_Completeness and    -- don't output
            CompleteADT.Undeterminable)      -- 304 twice.
   then
      ErrorHandler.Semantic_Warning
        (Err_Num  => 304,
         Position => Node_Position (Node => Node),
         Id_Str   => LexTokenManager.Null_String);
   end if;

   if CaseFlags.Others_Mandatory and not OthersFound then
      ErrorHandler.Semantic_Error
        (Err_Num   => 411,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   end if;
   --# accept Flow, 33, Unused1, "Expected to be neither referenced nor exported" &
   --#        Flow, 33, Unused2, "Expected to be neither referenced nor exported" &
   --#        Flow, 33, Unused3, "Expected to be neither referenced nor exported";
end up_case;
