-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.CompUnit)
procedure CheckAnnouncedTypesDeclared (PackSym : in Dictionary.Symbol;
                                       Scope   : in Dictionary.Scopes;
                                       Node    : in STree.SyntaxNode) is

   TypeList : Dictionary.Iterator;
   TheType  : Dictionary.Symbol;

   function TypeIsProtected (TheType : in Dictionary.Symbol;
                             PackSym : in Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   --#        in Scope;
   is
      -- This function is necessary because at this point the type symbol is
      -- simply a placeholder generated from the type announcement and contains
      -- no information as to what the type is. So we must iterate over the own
      -- variables looking for this type and then we can deduce whether the
      -- type is protected.
      OwnList   : Dictionary.Iterator;
      TheOwnVar : Dictionary.Symbol;
      Result    : Boolean := False;
   begin
      OwnList := Dictionary.FirstOwnVariable (PackSym);
      while not Dictionary.IsNullIterator (OwnList) loop
         TheOwnVar := Dictionary.CurrentSymbol (OwnList);
         if Dictionary.OwnVariableHasType (TheOwnVar, Scope)
           and then Dictionary.GetType (TheOwnVar) = TheType
           and then Dictionary.HasValidPriorityProperty (TheOwnVar) then
            Result := True;
            exit;
         end if;
         OwnList := Dictionary.NextSymbol (OwnList);
      end loop;
      return Result;
   end TypeIsProtected;

   function TypeIsTask (TheType : in Dictionary.Symbol;
                        PackSym : in Dictionary.Symbol) return Boolean
   --# global in Dictionary.Dict;
   is
      -- As above but looking through the own tasks.
      OwnList    : Dictionary.Iterator;
      TheOwnTask : Dictionary.Symbol;
      Result     : Boolean := False;
   begin
      OwnList := Dictionary.FirstOwnTask (PackSym);
      while not Dictionary.IsNullIterator (OwnList) loop
         TheOwnTask := Dictionary.CurrentSymbol (OwnList);
         if Dictionary.GetType (TheOwnTask) = TheType then
            Result := True;
            exit;
         end if;
         OwnList := Dictionary.NextSymbol (OwnList);
      end loop;
      return Result;
   end TypeIsTask;

begin
   TypeList := Dictionary.FirstUndeclaredType (PackSym);
   while not Dictionary.IsNullIterator (TypeList) loop
      TheType := Dictionary.CurrentSymbol (TypeList);

      -- Are we in the package specification?

      --# accept Flow, 41, "Expected stable expression";
      if Dictionary.IsVisibleScope (Scope) then
         --# end accept;
         if TypeIsProtected (TheType, PackSym) or else TypeIsTask (TheType, PackSym) then

            ErrorHandler.Semantic_Error
              (Err_Num   => 325,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => Dictionary.GetSimpleName (TheType));
         end if;

      else
         -- We're in the package body..
         if not Dictionary.TypeIsPrivate (Dictionary.CurrentSymbol (TypeList))
           and then not TypeIsProtected (TheType, PackSym)
           and then not TypeIsTask (TheType, PackSym) then
            ErrorHandler.Semantic_Error
              (Err_Num   => 325,
               Reference => ErrorHandler.No_Reference,
               Position  => Node_Position (Node => Node),
               Id_Str    => Dictionary.GetSimpleName (TheType));
         end if;
      end if;

      TypeList := Dictionary.NextSymbol (TypeList);
   end loop;
end CheckAnnouncedTypesDeclared;
