-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
function IsValidGenericTypeAssociation (Formal, Actual : Symbol;
                                        Scope          : Scopes) return Boolean is
   Result     : Boolean;
   FormalSort : GenericType;
begin
   FormalSort := RawDict.GetTypeDiscriminant (Formal);
   case FormalSort is
      when GenericLimitedType =>
         Result := True;
      when GenericPrivateType =>
         Result := not TypeIsLimited (Actual, Scope);
      when GenericOrderedDiscreteType =>
         Result := TypeIsDiscrete (Actual) and then not TypeIsBoolean (Actual);
      when GenericUnorderedDiscreteType =>
         Result := TypeIsDiscrete (Actual);
      when GenericIntegerType =>
         Result := TypeIsInteger (Actual);
      when GenericModularType =>
         Result := TypeIsModular (Actual);
      when GenericFloatingPointType =>
         Result := TypeIsFloatingPoint (Actual);
      when GenericFixedPointType =>
         Result := TypeIsFixedPoint (Actual);
         -- case below unreachable or at least unused.  The checking of array conformance is
         -- done in wffs using this function to check each index and element type
      when GenericArrayType =>
         SystemErrors.RT_Assert
           (C       => False,
            Sys_Err => SystemErrors.Assertion_Failure,
            Msg     => "Call to IsValidGenericTypeAssociation with array type");
         Result := False;
   end case;
   return Result;
end IsValidGenericTypeAssociation;
