(**************************************************************************)
(*                                                                        *)
(*     The Alt-ergo theorem prover                                        *)
(*     Copyright (C) 2006-2010                                            *)
(*                                                                        *)
(*     Sylvain Conchon                                                    *)
(*     Evelyne Contejean                                                  *)
(*     Stephane Lescuyer                                                  *)
(*     Mohamed Iguernelala                                                *)
(*     Alain Mebsout                                                      *)
(*                                                                        *)
(*     CNRS - INRIA - Universite Paris Sud                                *)
(*                                                                        *)
(*   This file is distributed under the terms of the CeCILL-C licence     *)
(*                                                                        *)
(**************************************************************************)

module Time : sig

  val start: unit -> unit

  val get: unit -> float

end

type output = Unsat | Inconsistent | Sat | Unknown



val process_decl:
  (Why_ptree.sat_tdecl -> output -> 'a) ->
  Sat.t * bool -> Why_ptree.sat_tdecl -> Sat.t * bool

val open_file:
  string -> Lexing.lexbuf -> 
  (Why_ptree.tdecl * Why_typing.env) list list * Smt_ast.status

val processing:
  (Why_ptree.sat_tdecl -> output -> 'a) -> 
  (Why_ptree.tdecl * Why_typing.env) list list -> unit
