(**************************************************************************)
(*                                                                        *)
(*     The Alt-ergo theorem prover                                        *)
(*     Copyright (C) 2006-2010                                            *)
(*                                                                        *)
(*     Sylvain Conchon                                                    *)
(*     Evelyne Contejean                                                  *)
(*     Stephane Lescuyer                                                  *)
(*     Mohamed Iguernelala                                                *)
(*     Alain Mebsout                                                      *)
(*                                                                        *)
(*     CNRS - INRIA - Universite Paris Sud                                *)
(*                                                                        *)
(*   This file is distributed under the terms of the CeCILL-C licence     *)
(*                                                                        *)
(**************************************************************************)

open Why_ptree

let _ = 
  Sys.set_signal Sys.sigint 
    (Sys.Signal_handle 
       (fun _ -> print_endline "User wants me to stop."; exit 1))

open Lexing
open Format
open Options

module Time = struct

  open Unix
    
  let u = ref 0.0
    
  let start () = u:=(times()).tms_utime

  let get () = 
    let res = (times()).tms_utime -. !u in
    start();
    res

end

(* let print_status fmt s =  *)
(*   fprintf fmt "%s@." *)
(*     ((function  *)
(* 	| Smt_ast.Unsat -> "unsat"  *)
(* 	| Smt_ast.Unknown -> "unknown" *)
(* 	| Smt_ast.Sat  -> "unknown (sat)") s) *)

type output = Unsat | Inconsistent | Sat | Unknown

let process_decl report (env, consistent) d =
  try
    match d.st_decl with
      | Assume(f,mf) -> 
	  Sat.assume env {Sat.f=f;age=0;name=None;mf=mf;gf=false}, consistent

      |	PredDef f -> 
	  Sat.pred_def env f , consistent

      | Query(n,f,lits)-> 
	  if consistent then
	    begin
	      Sat.unsat env 
		{Sat.f=f;age=0;name=None;mf=true;gf=true} stopb 
	    end;
	  report d Unsat;
	  env , consistent
  with 
    | Sat.Sat _ -> 
	report d Sat;
	env , consistent
    | Sat.Unsat -> 
	report d Inconsistent;
	env , false
    | Sat.I_dont_know -> 
	report d Unknown;
	env , consistent

let get_smt_prelude () =
  let libdir =
    try Sys.getenv "ERGOLIB"
    with Not_found -> Version.libdir
  in
  let f = Filename.concat libdir "smt_prelude.mlw"
  in
  from_channel (open_in f)

let open_file file lb =
  let d ,status =
    if !smtfile then begin
      let lb_prelude = get_smt_prelude () in 
      let lp = Why_parser.file Why_lexer.token lb_prelude in
      let bname,l,status = Smt_parser.benchmark Smt_lex.token lb in
      if verbose then printf "converting smt file : ";
      let l = List.flatten (List.map Smt_to_why.bench_to_why l) in
      if verbose then printf "done.@.";
      if parse_only then exit 0;
      let ltd = Why_typing.file (lp@l) in
      let lltd = Why_typing.split_goals ltd in
      lltd, status
    end
    else
      let a = Why_parser.file Why_lexer.token lb in
      if parse_only then exit 0;
      let ltd = Why_typing.file a in
      let lltd = Why_typing.split_goals ltd in
      lltd, Smt_ast.Unknown
  in
  if file <> " stdin" then close_in cin;
  if type_only then exit 0;
  d, status

let pruning = 
  List.map
    (fun d -> 
       if select > 0 then Pruning.split_and_prune select d 
       else [List.map (fun f -> f,true) d])
    
let processing report declss = 
  let declss = List.map (List.map fst) declss in
  List.iter
    (List.iter 
       (fun dcl ->
	  let cnf = Cnf.make dcl in 
	  ignore (Queue.fold (process_decl report) (Sat.empty,true) cnf)
       )) (pruning declss)
