------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                  POLYORB.POA_POLICIES.LIFESPAN_POLICY                    --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2001-2012, Free Software Foundation, Inc.          --
--                                                                          --
-- This is free software;  you can redistribute it  and/or modify it  under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 3,  or (at your option) any later ver- --
-- sion.  This software is distributed in the hope  that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License for  more details.                                               --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with PolyORB.POA_Types;

package PolyORB.POA_Policies.Lifespan_Policy is

   use PolyORB.POA_Types;

   type LifespanPolicy is abstract new Policy with null record;

   type LifespanPolicy_Access is access all LifespanPolicy'Class;

   function Get_Lifespan_Cookie
     (P  : LifespanPolicy;
      OA : PolyORB.POA_Types.Obj_Adapter_Access)
     return Lifespan_Cookie
      is abstract;

   procedure Ensure_Lifespan
     (P     :        LifespanPolicy;
      OA    :        PolyORB.POA_Types.Obj_Adapter_Access;
      U_Oid :        Unmarshalled_Oid;
      Error : in out PolyORB.Errors.Error_Container)
      is abstract;
   --  TRANSIENT:
   --  Ensure that the Oid has been generated by the current instantiation
   --  of the POA. If not, raises a OBJECT_NOT_EXIST exception.
   --  PERSISTENT:
   --  Does nothing.

end PolyORB.POA_Policies.Lifespan_Policy;
