package body Idl_Fe.Tree is

   use Nodes_Table;

   function Make_Add_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Add_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Add_Expr;

   function Is_Add_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Add_Expr
        or else False;
   end Is_Add_Expr;

   function Make_And_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_And_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_And_Expr;

   function Is_And_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_And_Expr
        or else False;
   end Is_And_Expr;

   function Make_Any (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Any;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Any;

   function Is_Any (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Any
        or else False;
   end Is_Any;

   function Make_Attribute (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Attribute;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Attribute;

   function Is_Attribute (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Attribute
        or else False;
   end Is_Attribute;

   function Make_Ben_Idl_File (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Ben_Idl_File;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Is_Unknown := False;
      Node.Generate_Code := True;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Ben_Idl_File;

   function Is_Ben_Idl_File (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Ben_Idl_File
        or else False;
   end Is_Ben_Idl_File;

   function Make_Binary_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Binary_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Binary_Expr;

   function Is_Binary_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Binary_Expr
        or else Is_Or_Expr (N)
        or else Is_Xor_Expr (N)
        or else Is_And_Expr (N)
        or else Is_Shl_Expr (N)
        or else Is_Shr_Expr (N)
        or else Is_Add_Expr (N)
        or else Is_Sub_Expr (N)
        or else Is_Mul_Expr (N)
        or else Is_Div_Expr (N)
        or else Is_Mod_Expr (N)
        or else False;
   end Is_Binary_Expr;

   function Make_Boolean (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Boolean;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Boolean;

   function Is_Boolean (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Boolean
        or else False;
   end Is_Boolean;

   function Make_Boxed_ValueType (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Boxed_ValueType;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Boxed_ValueType;

   function Is_Boxed_ValueType (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Boxed_ValueType
        or else False;
   end Is_Boxed_ValueType;

   function Make_Case (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Case;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Case;

   function Is_Case (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Case
        or else False;
   end Is_Case;

   function Make_Char (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Char;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Char;

   function Is_Char (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Char
        or else False;
   end Is_Char;

   function Make_Const_Dcl (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Const_Dcl;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Const_Dcl;

   function Is_Const_Dcl (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Const_Dcl
        or else False;
   end Is_Const_Dcl;

   function Make_Declarator (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Declarator;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Declarator;

   function Is_Declarator (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Declarator
        or else False;
   end Is_Declarator;

   function Make_Div_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Div_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Div_Expr;

   function Is_Div_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Div_Expr
        or else False;
   end Is_Div_Expr;

   function Make_Double (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Double;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Double;

   function Is_Double (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Double
        or else False;
   end Is_Double;

   function Make_Enum (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Enum;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Enum;

   function Is_Enum (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Enum
        or else False;
   end Is_Enum;

   function Make_Enumerator (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Enumerator;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Enumerator;

   function Is_Enumerator (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Enumerator
        or else False;
   end Is_Enumerator;

   function Make_Exception (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Exception;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Members_Type := No_Node;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Exception;

   function Is_Exception (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Exception
        or else False;
   end Is_Exception;

   function Make_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Expr;

   function Is_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Expr
        or else Is_Binary_Expr (N)
        or else Is_Unary_Expr (N)
        or else Is_Primary_Expr (N)
        or else Is_Literal (N)
        or else False;
   end Is_Expr;

   function Make_Fixed (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Fixed;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Fixed;

   function Is_Fixed (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Fixed
        or else False;
   end Is_Fixed;

   function Make_Float (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Float;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Float;

   function Is_Float (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Float
        or else False;
   end Is_Float;

   function Make_Forward (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Forward;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Forward;

   function Is_Forward (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Forward
        or else Is_Repository (N)
        or else Is_Module (N)
        or else False;
   end Is_Forward;

   function Make_Forward_Interface (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Forward_Interface;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Forward_Interface;

   function Is_Forward_Interface (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Forward_Interface
        or else False;
   end Is_Forward_Interface;

   function Make_Forward_ValueType (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Forward_ValueType;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Forward_ValueType;

   function Is_Forward_ValueType (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Forward_ValueType
        or else False;
   end Is_Forward_ValueType;

   function Make_Id_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Id_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Id_Expr;

   function Is_Id_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Id_Expr
        or else False;
   end Is_Id_Expr;

   function Make_Imports (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Imports;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Imports;

   function Is_Imports (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Imports
        or else Is_Interface (N)
        or else Is_ValueType (N)
        or else False;
   end Is_Imports;

   function Make_Initializer (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Initializer;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Initializer;

   function Is_Initializer (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Initializer
        or else False;
   end Is_Initializer;

   function Make_Interface (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Interface;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Has_Non_Implicit_Inherited_Operations := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Interface;

   function Is_Interface (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Interface
        or else False;
   end Is_Interface;

   function Make_Lit_Boolean (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Boolean;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Boolean;

   function Is_Lit_Boolean (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Boolean
        or else False;
   end Is_Lit_Boolean;

   function Make_Lit_Character (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Character;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Character;

   function Is_Lit_Character (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Character
        or else False;
   end Is_Lit_Character;

   function Make_Lit_Enum (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Enum;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Enum;

   function Is_Lit_Enum (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Enum
        or else False;
   end Is_Lit_Enum;

   function Make_Lit_Fixed_Point (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Fixed_Point;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Fixed_Point;

   function Is_Lit_Fixed_Point (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Fixed_Point
        or else False;
   end Is_Lit_Fixed_Point;

   function Make_Lit_Floating_Point (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Floating_Point;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Floating_Point;

   function Is_Lit_Floating_Point (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Floating_Point
        or else False;
   end Is_Lit_Floating_Point;

   function Make_Lit_Integer (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Integer;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Integer;

   function Is_Lit_Integer (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Integer
        or else False;
   end Is_Lit_Integer;

   function Make_Lit_String (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_String;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_String;

   function Is_Lit_String (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_String
        or else False;
   end Is_Lit_String;

   function Make_Lit_Wide_Character (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Wide_Character;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Wide_Character;

   function Is_Lit_Wide_Character (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Wide_Character
        or else False;
   end Is_Lit_Wide_Character;

   function Make_Lit_Wide_String (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Lit_Wide_String;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Lit_Wide_String;

   function Is_Lit_Wide_String (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Lit_Wide_String
        or else False;
   end Is_Lit_Wide_String;

   function Make_Literal (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Literal;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Literal;

   function Is_Literal (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Literal
        or else Is_Lit_Integer (N)
        or else Is_Lit_String (N)
        or else Is_Lit_Wide_String (N)
        or else Is_Lit_Character (N)
        or else Is_Lit_Wide_Character (N)
        or else Is_Lit_Fixed_Point (N)
        or else Is_Lit_Floating_Point (N)
        or else Is_Lit_Boolean (N)
        or else Is_Lit_Enum (N)
        or else False;
   end Is_Literal;

   function Make_Long (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Long;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Long;

   function Is_Long (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Long
        or else False;
   end Is_Long;

   function Make_Long_Double (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Long_Double;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Long_Double;

   function Is_Long_Double (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Long_Double
        or else False;
   end Is_Long_Double;

   function Make_Long_Long (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Long_Long;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Long_Long;

   function Is_Long_Long (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Long_Long
        or else False;
   end Is_Long_Long;

   function Make_Member (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Member;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Member;

   function Is_Member (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Member
        or else False;
   end Is_Member;

   function Make_Mod_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Mod_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Mod_Expr;

   function Is_Mod_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Mod_Expr
        or else False;
   end Is_Mod_Expr;

   function Make_Module (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Module;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Module;

   function Is_Module (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Module
        or else False;
   end Is_Module;

   function Make_Mul_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Mul_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Mul_Expr;

   function Is_Mul_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Mul_Expr
        or else False;
   end Is_Mul_Expr;

   function Make_Named (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Named;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Named;

   function Is_Named (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Named
        or else Is_Scope (N)
        or else Is_Forward_Interface (N)
        or else Is_Forward_ValueType (N)
        or else Is_Boxed_ValueType (N)
        or else Is_Declarator (N)
        or else Is_Enum (N)
        or else Is_Enumerator (N)
        or else Is_Const_Dcl (N)
        or else Is_Sequence_Instance (N)
        or else Is_String_Instance (N)
        or else False;
   end Is_Named;

   function Make_Native (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Native;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Native;

   function Is_Native (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Native
        or else False;
   end Is_Native;

   function Make_Neg_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Neg_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Neg_Expr;

   function Is_Neg_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Neg_Expr
        or else False;
   end Is_Neg_Expr;

   function Make_Not_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Not_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Not_Expr;

   function Is_Not_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Not_Expr
        or else False;
   end Is_Not_Expr;

   function Make_Object (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Object;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Object;

   function Is_Object (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Object
        or else False;
   end Is_Object;

   function Make_Octet (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Octet;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Octet;

   function Is_Octet (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Octet
        or else False;
   end Is_Octet;

   function Make_Operation (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Operation;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Is_Explicit_Self := False;
      Node.Is_Implicit_Inherited := False;
      Node.Is_Directly_Supported := False;
      Node.Oldest_Supporting_ValueType := No_Node;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Operation;

   function Is_Operation (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Operation
        or else False;
   end Is_Operation;

   function Make_Or_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Or_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Or_Expr;

   function Is_Or_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Or_Expr
        or else False;
   end Is_Or_Expr;

   function Make_Param (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Param;
      Node.Expanded := False;
      Node.Is_Returns := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Param;

   function Is_Param (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Param
        or else False;
   end Is_Param;

   function Make_Pragma (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Pragma;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Pragma;

   function Is_Pragma (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Pragma
        or else False;
   end Is_Pragma;

   function Make_Primary_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Primary_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Primary_Expr;

   function Is_Primary_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Primary_Expr
        or else False;
   end Is_Primary_Expr;

   function Make_Repository (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Repository;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Repository;

   function Is_Repository (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Repository
        or else False;
   end Is_Repository;

   function Make_Scope (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Scope;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Scope;

   function Is_Scope (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Scope
        or else Is_Forward (N)
        or else Is_Imports (N)
        or else Is_Initializer (N)
        or else Is_Operation (N)
        or else Is_Exception (N)
        or else Is_Union (N)
        or else Is_Struct (N)
        or else Is_Ben_Idl_File (N)
        or else False;
   end Is_Scope;

   function Make_Scoped_Name (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Scoped_Name;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Scoped_Name;

   function Is_Scoped_Name (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Scoped_Name
        or else False;
   end Is_Scoped_Name;

   function Make_Sequence (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Sequence;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Sequence;

   function Is_Sequence (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Sequence
        or else False;
   end Is_Sequence;

   function Make_Sequence_Instance (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Sequence_Instance;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Sequence_Instance;

   function Is_Sequence_Instance (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Sequence_Instance
        or else False;
   end Is_Sequence_Instance;

   function Make_Shl_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Shl_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Shl_Expr;

   function Is_Shl_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Shl_Expr
        or else False;
   end Is_Shl_Expr;

   function Make_Short (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Short;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Short;

   function Is_Short (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Short
        or else False;
   end Is_Short;

   function Make_Shr_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Shr_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Shr_Expr;

   function Is_Shr_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Shr_Expr
        or else False;
   end Is_Shr_Expr;

   function Make_State_Member (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_State_Member;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_State_Member;

   function Is_State_Member (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_State_Member
        or else False;
   end Is_State_Member;

   function Make_String (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_String;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_String;

   function Is_String (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_String
        or else False;
   end Is_String;

   function Make_String_Instance (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_String_Instance;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_String_Instance;

   function Is_String_Instance (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_String_Instance
        or else False;
   end Is_String_Instance;

   function Make_Struct (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Struct;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Is_Exception_Members := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Struct;

   function Is_Struct (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Struct
        or else False;
   end Is_Struct;

   function Make_Sub_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Sub_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Sub_Expr;

   function Is_Sub_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Sub_Expr
        or else False;
   end Is_Sub_Expr;

   function Make_Type_Declarator (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Type_Declarator;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Type_Declarator;

   function Is_Type_Declarator (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Type_Declarator
        or else False;
   end Is_Type_Declarator;

   function Make_Unary_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Unary_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Unary_Expr;

   function Is_Unary_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Unary_Expr
        or else Is_Neg_Expr (N)
        or else Is_Id_Expr (N)
        or else Is_Not_Expr (N)
        or else False;
   end Is_Unary_Expr;

   function Make_Union (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Union;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Node.Default_Index := -1;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Union;

   function Is_Union (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Union
        or else False;
   end Is_Union;

   function Make_Unsigned_Long (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Unsigned_Long;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Unsigned_Long;

   function Is_Unsigned_Long (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Unsigned_Long
        or else False;
   end Is_Unsigned_Long;

   function Make_Unsigned_Long_Long (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Unsigned_Long_Long;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Unsigned_Long_Long;

   function Is_Unsigned_Long_Long (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Unsigned_Long_Long
        or else False;
   end Is_Unsigned_Long_Long;

   function Make_Unsigned_Short (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Unsigned_Short;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Unsigned_Short;

   function Is_Unsigned_Short (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Unsigned_Short
        or else False;
   end Is_Unsigned_Short;

   function Make_ValueBase (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_ValueBase;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_ValueBase;

   function Is_ValueBase (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_ValueBase
        or else False;
   end Is_ValueBase;

   function Make_ValueType (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_ValueType;
      Node.Expanded := False;
      Node.Is_Explicit_Repository_Id := False;
      Node.Is_Explicit_Version_Id := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_ValueType;

   function Is_ValueType (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_ValueType
        or else False;
   end Is_ValueType;

   function Make_Void (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Void;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Void;

   function Is_Void (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Void
        or else False;
   end Is_Void;

   function Make_Wide_Char (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Wide_Char;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Wide_Char;

   function Is_Wide_Char (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Wide_Char
        or else False;
   end Is_Wide_Char;

   function Make_Wide_String (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Wide_String;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Wide_String;

   function Is_Wide_String (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Wide_String
        or else False;
   end Is_Wide_String;

   function Make_Xor_Expr (Loc : Location) return Node_Id is
      Node  : constant Node_Access := new Node_Type;
      Index : constant Node_Id     := Nodes_Table.Allocate;
   begin
      Node.Loc := Loc;
      Node.Kind := K_Xor_Expr;
      Node.Expanded := False;
      Nodes_Table.Table (Index) := Node;
      return Index;
   end Make_Xor_Expr;

   function Is_Xor_Expr (N : Node_Id) return Boolean is
   begin
      return Kind (N) = K_Xor_Expr
        or else False;
   end Is_Xor_Expr;

   function A_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      return Node.A_Type;
   end A_Type;

   procedure Set_A_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      Node.A_Type := V;
   end Set_A_Type;

   function Abst
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      return Node.Abst;
   end Abst;

   procedure Set_Abst
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      Node.Abst := V;
   end Set_Abst;

   function Array_Bounds
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Declarator);
      return Node.Array_Bounds;
   end Array_Bounds;

   procedure Set_Array_Bounds
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Declarator);
      Node.Array_Bounds := V;
   end Set_Array_Bounds;

   procedure Append_Node_To_Array_Bounds
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Array_Bounds
        (N, Append_Node (Array_Bounds (N), V));
   end Append_Node_To_Array_Bounds;

   function Bound
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Wide_String);
      return Node.Bound;
   end Bound;

   procedure Set_Bound
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Wide_String);
      Node.Bound := V;
   end Set_Bound;

   function Boxed_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Boxed_ValueType);
      return Node.Boxed_Type;
   end Boxed_Type;

   procedure Set_Boxed_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Boxed_ValueType);
      Node.Boxed_Type := V;
   end Set_Boxed_Type;

   function Case_Decl
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      return Node.Case_Decl;
   end Case_Decl;

   procedure Set_Case_Decl
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      Node.Case_Decl := V;
   end Set_Case_Decl;

   function Case_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      return Node.Case_Type;
   end Case_Type;

   procedure Set_Case_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      Node.Case_Type := V;
   end Set_Case_Type;

   function Cases
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      return Node.Cases;
   end Cases;

   procedure Set_Cases
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      Node.Cases := V;
   end Set_Cases;

   procedure Append_Node_To_Cases
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Cases
        (N, Append_Node (Cases (N), V));
   end Append_Node_To_Cases;

   function Constant_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Const_Dcl);
      return Node.Constant_Type;
   end Constant_Type;

   procedure Set_Constant_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Const_Dcl);
      Node.Constant_Type := V;
   end Set_Constant_Type;

   function Contents
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Repository
             or else Node.Kind = K_ValueType);
      return Node.Contents;
   end Contents;

   procedure Set_Contents
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Repository
             or else Node.Kind = K_ValueType);
      Node.Contents := V;
   end Set_Contents;

   procedure Append_Node_To_Contents
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Contents
        (N, Append_Node (Contents (N), V));
   end Append_Node_To_Contents;

   function Contexts
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Contexts;
   end Contexts;

   procedure Set_Contexts
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Contexts := V;
   end Set_Contexts;

   procedure Append_Node_To_Contexts
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Contexts
        (N, Append_Node (Contexts (N), V));
   end Append_Node_To_Contexts;

   function Current_Prefix
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Current_Prefix;
   end Current_Prefix;

   procedure Set_Current_Prefix
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Current_Prefix := V;
   end Set_Current_Prefix;

   function Custom
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      return Node.Custom;
   end Custom;

   procedure Set_Custom
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      Node.Custom := V;
   end Set_Custom;

   function Decl
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Member);
      return Node.Decl;
   end Decl;

   procedure Set_Decl
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Member);
      Node.Decl := V;
   end Set_Decl;

   procedure Append_Node_To_Decl
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Decl
        (N, Append_Node (Decl (N), V));
   end Append_Node_To_Decl;

   function Declarator
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Native
             or else Node.Kind = K_Param);
      return Node.Declarator;
   end Declarator;

   procedure Set_Declarator
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Native
             or else Node.Kind = K_Param);
      Node.Declarator := V;
   end Set_Declarator;

   function Declarators
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute
             or else Node.Kind = K_Type_Declarator);
      return Node.Declarators;
   end Declarators;

   procedure Set_Declarators
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute
             or else Node.Kind = K_Type_Declarator);
      Node.Declarators := V;
   end Set_Declarators;

   procedure Append_Node_To_Declarators
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Declarators
        (N, Append_Node (Declarators (N), V));
   end Append_Node_To_Declarators;

   function Default_Index
     (N : Node_Id) return Long_Integer
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      return Node.Default_Index;
   end Default_Index;

   procedure Set_Default_Index
     (N : Node_Id; V : Long_Integer)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      Node.Default_Index := V;
   end Set_Default_Index;

   function Definition
     (N : Node_Id) return Identifier_Definition_Acc
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Definition;
   end Definition;

   procedure Set_Definition
     (N : Node_Id; V : Identifier_Definition_Acc)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Definition := V;
   end Set_Definition;

   function Digits_Nb
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Fixed);
      return Node.Digits_Nb;
   end Digits_Nb;

   procedure Set_Digits_Nb
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Fixed);
      Node.Digits_Nb := V;
   end Set_Digits_Nb;

   function Enumerators
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Enum);
      return Node.Enumerators;
   end Enumerators;

   procedure Set_Enumerators
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Enum);
      Node.Enumerators := V;
   end Set_Enumerators;

   procedure Append_Node_To_Enumerators
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Enumerators
        (N, Append_Node (Enumerators (N), V));
   end Append_Node_To_Enumerators;

   function Expanded
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      return Node.Expanded;
   end Expanded;

   procedure Set_Expanded
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      Node.Expanded := V;
   end Set_Expanded;

   function Expr_Value
     (N : Node_Id) return Constant_Value_Ptr
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Xor_Expr);
      return Node.Expr_Value;
   end Expr_Value;

   procedure Set_Expr_Value
     (N : Node_Id; V : Constant_Value_Ptr)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Xor_Expr);
      Node.Expr_Value := V;
   end Set_Expr_Value;

   function Expression
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Const_Dcl);
      return Node.Expression;
   end Expression;

   procedure Set_Expression
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Const_Dcl);
      Node.Expression := V;
   end Set_Expression;

   function Forward
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      return Node.Forward;
   end Forward;

   procedure Set_Forward
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      Node.Forward := V;
   end Set_Forward;

   function Generate_Code
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File);
      return Node.Generate_Code;
   end Generate_Code;

   procedure Set_Generate_Code
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File);
      Node.Generate_Code := V;
   end Set_Generate_Code;

   function Get_Raises
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      return Node.Get_Raises;
   end Get_Raises;

   procedure Set_Get_Raises
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      Node.Get_Raises := V;
   end Set_Get_Raises;

   procedure Append_Node_To_Get_Raises
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Get_Raises
        (N, Append_Node (Get_Raises (N), V));
   end Append_Node_To_Get_Raises;

   function Has_Non_Implicit_Inherited_Operations
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Interface);
      return Node.Has_Non_Implicit_Inherited_Operations;
   end Has_Non_Implicit_Inherited_Operations;

   procedure Set_Has_Non_Implicit_Inherited_Operations
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Interface);
      Node.Has_Non_Implicit_Inherited_Operations := V;
   end Set_Has_Non_Implicit_Inherited_Operations;

   function Identifier_List
     (N : Node_Id) return Identifier_Definition_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Identifier_List;
   end Identifier_List;

   procedure Set_Identifier_List
     (N : Node_Id; V : Identifier_Definition_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Identifier_List := V;
   end Set_Identifier_List;

   function Identifier_Table
     (N : Node_Id) return Storage
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Identifier_Table;
   end Identifier_Table;

   procedure Set_Identifier_Table
     (N : Node_Id; V : Storage)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Identifier_Table := V;
   end Set_Identifier_Table;

   function Imported
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Enum
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Imported;
   end Imported;

   procedure Set_Imported
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Enum
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Imported := V;
   end Set_Imported;

   function Imported_Table
     (N : Node_Id) return Storage
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Imports
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      return Node.Imported_Table;
   end Imported_Table;

   procedure Set_Imported_Table
     (N : Node_Id; V : Storage)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Imports
             or else Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      Node.Imported_Table := V;
   end Set_Imported_Table;

   function Is_Directly_Supported
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Is_Directly_Supported;
   end Is_Directly_Supported;

   procedure Set_Is_Directly_Supported
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Is_Directly_Supported := V;
   end Set_Is_Directly_Supported;

   function Is_Exception_Members
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Struct);
      return Node.Is_Exception_Members;
   end Is_Exception_Members;

   procedure Set_Is_Exception_Members
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Struct);
      Node.Is_Exception_Members := V;
   end Set_Is_Exception_Members;

   function Is_Explicit_Repository_Id
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Is_Explicit_Repository_Id;
   end Is_Explicit_Repository_Id;

   procedure Set_Is_Explicit_Repository_Id
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Is_Explicit_Repository_Id := V;
   end Set_Is_Explicit_Repository_Id;

   function Is_Explicit_Self
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Is_Explicit_Self;
   end Is_Explicit_Self;

   procedure Set_Is_Explicit_Self
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Is_Explicit_Self := V;
   end Set_Is_Explicit_Self;

   function Is_Explicit_Version_Id
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Is_Explicit_Version_Id;
   end Is_Explicit_Version_Id;

   procedure Set_Is_Explicit_Version_Id
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Is_Explicit_Version_Id := V;
   end Set_Is_Explicit_Version_Id;

   function Is_Implicit_Inherited
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Is_Implicit_Inherited;
   end Is_Implicit_Inherited;

   procedure Set_Is_Implicit_Inherited
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Is_Implicit_Inherited := V;
   end Set_Is_Implicit_Inherited;

   function Is_Oneway
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Is_Oneway;
   end Is_Oneway;

   procedure Set_Is_Oneway
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Is_Oneway := V;
   end Set_Is_Oneway;

   function Is_Public
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      return Node.Is_Public;
   end Is_Public;

   procedure Set_Is_Public
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      Node.Is_Public := V;
   end Set_Is_Public;

   function Is_Readonly
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      return Node.Is_Readonly;
   end Is_Readonly;

   procedure Set_Is_Readonly
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      Node.Is_Readonly := V;
   end Set_Is_Readonly;

   function Is_Returns
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      return Node.Is_Returns;
   end Is_Returns;

   procedure Set_Is_Returns
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      Node.Is_Returns := V;
   end Set_Is_Returns;

   function Is_Unknown
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File);
      return Node.Is_Unknown;
   end Is_Unknown;

   procedure Set_Is_Unknown
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File);
      Node.Is_Unknown := V;
   end Set_Is_Unknown;

   function Is_Wide
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_String_Instance);
      return Node.Is_Wide;
   end Is_Wide;

   procedure Set_Is_Wide
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_String_Instance);
      Node.Is_Wide := V;
   end Set_Is_Wide;

   function Kind
     (N : Node_Id) return Node_Kind
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      return Node.Kind;
   end Kind;

   procedure Set_Kind
     (N : Node_Id; V : Node_Kind)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      Node.Kind := V;
   end Set_Kind;

   function Labels
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      return Node.Labels;
   end Labels;

   procedure Set_Labels
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Case);
      Node.Labels := V;
   end Set_Labels;

   procedure Append_Node_To_Labels
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Labels
        (N, Append_Node (Labels (N), V));
   end Append_Node_To_Labels;

   function Left
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Xor_Expr);
      return Node.Left;
   end Left;

   procedure Set_Left
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Xor_Expr);
      Node.Left := V;
   end Set_Left;

   function Loc
     (N : Node_Id) return Location
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      return Node.Loc;
   end Loc;

   procedure Set_Loc
     (N : Node_Id; V : Location)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      Node.Loc := V;
   end Set_Loc;

   function Local
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Interface);
      return Node.Local;
   end Local;

   procedure Set_Local
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Interface);
      Node.Local := V;
   end Set_Local;

   function M_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Member);
      return Node.M_Type;
   end M_Type;

   procedure Set_M_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Member);
      Node.M_Type := V;
   end Set_M_Type;

   function Members
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Exception
             or else Node.Kind = K_Struct);
      return Node.Members;
   end Members;

   procedure Set_Members
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Exception
             or else Node.Kind = K_Struct);
      Node.Members := V;
   end Set_Members;

   procedure Append_Node_To_Members
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Members
        (N, Append_Node (Members (N), V));
   end Append_Node_To_Members;

   function Members_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Exception);
      return Node.Members_Type;
   end Members_Type;

   procedure Set_Members_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Exception);
      Node.Members_Type := V;
   end Set_Members_Type;

   function Mode
     (N : Node_Id) return Param_Mode
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      return Node.Mode;
   end Mode;

   procedure Set_Mode
     (N : Node_Id; V : Param_Mode)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      Node.Mode := V;
   end Set_Mode;

   function Oldest_Supporting_ValueType
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Oldest_Supporting_ValueType;
   end Oldest_Supporting_ValueType;

   procedure Set_Oldest_Supporting_ValueType
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Oldest_Supporting_ValueType := V;
   end Set_Oldest_Supporting_ValueType;

   function Operand
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Id_Expr
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Unary_Expr);
      return Node.Operand;
   end Operand;

   procedure Set_Operand
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Id_Expr
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Unary_Expr);
      Node.Operand := V;
   end Set_Operand;

   function Operation_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Operation_Type;
   end Operation_Type;

   procedure Set_Operation_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Operation_Type := V;
   end Set_Operation_Type;

   function Original_Node
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      return Node.Original_Node;
   end Original_Node;

   procedure Set_Original_Node
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Any
             or else Node.Kind = K_Attribute
             or else Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Boolean
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Case
             or else Node.Kind = K_Char
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Double
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Expr
             or else Node.Kind = K_Fixed
             or else Node.Kind = K_Float
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Id_Expr
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Lit_Boolean
             or else Node.Kind = K_Lit_Character
             or else Node.Kind = K_Lit_Enum
             or else Node.Kind = K_Lit_Fixed_Point
             or else Node.Kind = K_Lit_Floating_Point
             or else Node.Kind = K_Lit_Integer
             or else Node.Kind = K_Lit_String
             or else Node.Kind = K_Lit_Wide_Character
             or else Node.Kind = K_Lit_Wide_String
             or else Node.Kind = K_Literal
             or else Node.Kind = K_Long
             or else Node.Kind = K_Long_Double
             or else Node.Kind = K_Long_Long
             or else Node.Kind = K_Member
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Module
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Named
             or else Node.Kind = K_Native
             or else Node.Kind = K_Neg_Expr
             or else Node.Kind = K_Not_Expr
             or else Node.Kind = K_Object
             or else Node.Kind = K_Octet
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Param
             or else Node.Kind = K_Pragma
             or else Node.Kind = K_Primary_Expr
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Scoped_Name
             or else Node.Kind = K_Sequence
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Short
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_State_Member
             or else Node.Kind = K_String
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Type_Declarator
             or else Node.Kind = K_Unary_Expr
             or else Node.Kind = K_Union
             or else Node.Kind = K_Unsigned_Long
             or else Node.Kind = K_Unsigned_Long_Long
             or else Node.Kind = K_Unsigned_Short
             or else Node.Kind = K_ValueBase
             or else Node.Kind = K_ValueType
             or else Node.Kind = K_Void
             or else Node.Kind = K_Wide_Char
             or else Node.Kind = K_Wide_String
             or else Node.Kind = K_Xor_Expr);
      Node.Original_Node := V;
   end Set_Original_Node;

   function Param_Decls
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Initializer);
      return Node.Param_Decls;
   end Param_Decls;

   procedure Set_Param_Decls
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Initializer);
      Node.Param_Decls := V;
   end Set_Param_Decls;

   procedure Append_Node_To_Param_Decls
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Param_Decls
        (N, Append_Node (Param_Decls (N), V));
   end Append_Node_To_Param_Decls;

   function Param_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      return Node.Param_Type;
   end Param_Type;

   procedure Set_Param_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Param);
      Node.Param_Type := V;
   end Set_Param_Type;

   function Parameters
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      return Node.Parameters;
   end Parameters;

   procedure Set_Parameters
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Operation);
      Node.Parameters := V;
   end Set_Parameters;

   procedure Append_Node_To_Parameters
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Parameters
        (N, Append_Node (Parameters (N), V));
   end Append_Node_To_Parameters;

   function Parent
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Declarator);
      return Node.Parent;
   end Parent;

   procedure Set_Parent
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Declarator);
      Node.Parent := V;
   end Set_Parent;

   function Parent_Scope_Override
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Parent_Scope_Override;
   end Parent_Scope_Override;

   procedure Set_Parent_Scope_Override
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Parent_Scope_Override := V;
   end Set_Parent_Scope_Override;

   function Parents
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      return Node.Parents;
   end Parents;

   procedure Set_Parents
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Interface
             or else Node.Kind = K_ValueType);
      Node.Parents := V;
   end Set_Parents;

   procedure Append_Node_To_Parents
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Parents
        (N, Append_Node (Parents (N), V));
   end Append_Node_To_Parents;

   function Raises
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute
             or else Node.Kind = K_Operation);
      return Node.Raises;
   end Raises;

   procedure Set_Raises
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute
             or else Node.Kind = K_Operation);
      Node.Raises := V;
   end Set_Raises;

   procedure Append_Node_To_Raises
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Raises
        (N, Append_Node (Raises (N), V));
   end Append_Node_To_Raises;

   function Repository_Id
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Repository_Id;
   end Repository_Id;

   procedure Set_Repository_Id
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Repository_Id := V;
   end Set_Repository_Id;

   function Repository_Id_Identifier
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      return Node.Repository_Id_Identifier;
   end Repository_Id_Identifier;

   procedure Set_Repository_Id_Identifier
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Ben_Idl_File
             or else Node.Kind = K_Boxed_ValueType
             or else Node.Kind = K_Const_Dcl
             or else Node.Kind = K_Declarator
             or else Node.Kind = K_Enum
             or else Node.Kind = K_Enumerator
             or else Node.Kind = K_Exception
             or else Node.Kind = K_Forward
             or else Node.Kind = K_Forward_Interface
             or else Node.Kind = K_Forward_ValueType
             or else Node.Kind = K_Imports
             or else Node.Kind = K_Initializer
             or else Node.Kind = K_Interface
             or else Node.Kind = K_Module
             or else Node.Kind = K_Named
             or else Node.Kind = K_Operation
             or else Node.Kind = K_Repository
             or else Node.Kind = K_Scope
             or else Node.Kind = K_Sequence_Instance
             or else Node.Kind = K_String_Instance
             or else Node.Kind = K_Struct
             or else Node.Kind = K_Union
             or else Node.Kind = K_ValueType);
      Node.Repository_Id_Identifier := V;
   end Set_Repository_Id_Identifier;

   function Right
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Xor_Expr);
      return Node.Right;
   end Right;

   procedure Set_Right
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Add_Expr
             or else Node.Kind = K_And_Expr
             or else Node.Kind = K_Binary_Expr
             or else Node.Kind = K_Div_Expr
             or else Node.Kind = K_Mod_Expr
             or else Node.Kind = K_Mul_Expr
             or else Node.Kind = K_Or_Expr
             or else Node.Kind = K_Shl_Expr
             or else Node.Kind = K_Shr_Expr
             or else Node.Kind = K_Sub_Expr
             or else Node.Kind = K_Xor_Expr);
      Node.Right := V;
   end Set_Right;

   function Scale
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Fixed);
      return Node.Scale;
   end Scale;

   procedure Set_Scale
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Fixed);
      Node.Scale := V;
   end Set_Scale;

   function Sequence
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence_Instance);
      return Node.Sequence;
   end Sequence;

   procedure Set_Sequence
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence_Instance);
      Node.Sequence := V;
   end Set_Sequence;

   function Sequence_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence);
      return Node.Sequence_Type;
   end Sequence_Type;

   procedure Set_Sequence_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Sequence);
      Node.Sequence_Type := V;
   end Set_Sequence_Type;

   function Set_Raises
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      return Node.Set_Raises;
   end Set_Raises;

   procedure Set_Set_Raises
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Attribute);
      Node.Set_Raises := V;
   end Set_Set_Raises;

   procedure Append_Node_To_Set_Raises
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Set_Raises
        (N, Append_Node (Set_Raises (N), V));
   end Append_Node_To_Set_Raises;

   function State_Declarators
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      return Node.State_Declarators;
   end State_Declarators;

   procedure Set_State_Declarators
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      Node.State_Declarators := V;
   end Set_State_Declarators;

   procedure Append_Node_To_State_Declarators
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_State_Declarators
        (N, Append_Node (State_Declarators (N), V));
   end Append_Node_To_State_Declarators;

   function State_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      return Node.State_Type;
   end State_Type;

   procedure Set_State_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_State_Member);
      Node.State_Type := V;
   end Set_State_Type;

   function Supports
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      return Node.Supports;
   end Supports;

   procedure Set_Supports
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      Node.Supports := V;
   end Set_Supports;

   procedure Append_Node_To_Supports
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Supports
        (N, Append_Node (Supports (N), V));
   end Append_Node_To_Supports;

   function Switch_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      return Node.Switch_Type;
   end Switch_Type;

   procedure Set_Switch_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Union);
      Node.Switch_Type := V;
   end Set_Switch_Type;

   function T_Type
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Type_Declarator);
      return Node.T_Type;
   end T_Type;

   procedure Set_T_Type
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Type_Declarator);
      Node.T_Type := V;
   end Set_T_Type;

   function Truncatable
     (N : Node_Id) return Boolean
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      return Node.Truncatable;
   end Truncatable;

   procedure Set_Truncatable
     (N : Node_Id; V : Boolean)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_ValueType);
      Node.Truncatable := V;
   end Set_Truncatable;

   function Unimplemented_Forwards
     (N : Node_Id) return Node_List
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward
             or else Node.Kind = K_Module
             or else Node.Kind = K_Repository);
      return Node.Unimplemented_Forwards;
   end Unimplemented_Forwards;

   procedure Set_Unimplemented_Forwards
     (N : Node_Id; V : Node_List)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Forward
             or else Node.Kind = K_Module
             or else Node.Kind = K_Repository);
      Node.Unimplemented_Forwards := V;
   end Set_Unimplemented_Forwards;

   procedure Append_Node_To_Unimplemented_Forwards
     (N : Node_Id; V : Node_Id)
   is
   begin
      Set_Unimplemented_Forwards
        (N, Append_Node (Unimplemented_Forwards (N), V));
   end Append_Node_To_Unimplemented_Forwards;

   function Value
     (N : Node_Id) return Node_Id
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Scoped_Name);
      return Node.Value;
   end Value;

   procedure Set_Value
     (N : Node_Id; V : Node_Id)
   is
      Node : constant Node_Access := Nodes_Table.Table (N);
   begin
      pragma Assert (Node.Kind = K_Scoped_Name);
      Node.Value := V;
   end Set_Value;

end Idl_Fe.Tree;
