------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--                      R A V E N S C A R _ S E T U P                       --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--            Copyright (C) 2003 Free Software Foundation, Inc.             --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 59 Temple Place - Suite 330, --
-- Boston, MA 02111-1307, USA.                                              --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                PolyORB is maintained by ACT Europe.                      --
--                    (email: sales@act-europe.fr)                          --
--                                                                          --
------------------------------------------------------------------------------

with System;

with PolyORB.Tasking.Profiles.Ravenscar.Threads;
with PolyORB.Tasking.Profiles.Ravenscar.Mutexes;
with PolyORB.Tasking.Profiles.Ravenscar.Condition_Variables;

package body Ravenscar_Setup is

   pragma Warnings (Off);

   --  No direct reference on these packages: they initializes hooks
   --  for the tasking runtime.

   package Threads_Package is
      new PolyORB.Tasking.Profiles.Ravenscar.Threads
     (4, 20, System.Default_Priority);

   package Conditions_Package is
      new PolyORB.Tasking.Profiles.Ravenscar.Condition_Variables
     (Threads_Package,
      1_000);

   package Mutexes_Package is
      new PolyORB.Tasking.Profiles.Ravenscar.Mutexes
     (Threads_Package,
      1_000);

   pragma Warnings (On);
end Ravenscar_Setup;
