------------------------------------------------------------------------------
--                                                                          --
--                           POLYORB COMPONENTS                             --
--                                                                          --
--      P O L Y O R B . S O A P _ P . M E S S A G E . R E S P O N S E       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--         Copyright (C) 2000-2006, Free Software Foundation, Inc.          --
--                                                                          --
-- PolyORB is free software; you  can  redistribute  it and/or modify it    --
-- under terms of the  GNU General Public License as published by the  Free --
-- Software Foundation;  either version 2,  or (at your option)  any  later --
-- version. PolyORB is distributed  in the hope that it will be  useful,    --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public --
-- License  for more details.  You should have received  a copy of the GNU  --
-- General Public License distributed with PolyORB; see file COPYING. If    --
-- not, write to the Free Software Foundation, 51 Franklin Street, Fifth    --
-- Floor, Boston, MA 02111-1301, USA.                                       --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                  PolyORB is maintained by AdaCore                        --
--                     (email: sales@adacore.com)                           --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Unchecked_Deallocation;

with PolyORB.SOAP_P.Response;
with PolyORB.SOAP_P.Message.Payload;

package PolyORB.SOAP_P.Message.Response is

   type Object is new Message.Object with null record;
   type Object_Access is access Object'Class;
   function Build (R : Object'Class) return PolyORB.SOAP_P.Response.Data;

   function From (P : Message.Payload.Object) return Object;
   --  Returns a Response object, initialized from a payload object.

   function Is_Error (R : Object) return Boolean;

   procedure Free is new Ada.Unchecked_Deallocation
     (Object'Class, Object_Access);

end PolyORB.SOAP_P.Message.Response;
